/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.hll;

import java.util.Arrays;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.hll.State;
import org.apache.datasketches.hive.hll.UnionState;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

abstract class SketchEvaluator
extends GenericUDAFEvaluator {
    static final int DEFAULT_LG_K = 12;
    static final TgtHllType DEFAULT_HLL_TYPE = TgtHllType.HLL_4;
    protected static final String LG_K_FIELD = "lgK";
    protected static final String HLL_TYPE_FIELD = "type";
    protected static final String SKETCH_FIELD = "sketch";
    protected PrimitiveObjectInspector inputInspector_;
    protected PrimitiveObjectInspector lgKInspector_;
    protected PrimitiveObjectInspector hllTypeInspector_;
    protected StructObjectInspector intermediateInspector_;

    SketchEvaluator() {
    }

    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        State state = (State)buf;
        HllSketch intermediate = state.getResult();
        if (intermediate == null) {
            return null;
        }
        byte[] bytes = intermediate.toCompactByteArray();
        return Arrays.asList(new IntWritable(state.getLgK()), new Text(state.getType().toString()), new BytesWritable(bytes));
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object data) throws HiveException {
        if (data == null) {
            return;
        }
        UnionState state = (UnionState)buf;
        if (!state.isInitialized()) {
            this.initializeState(state, data);
        }
        BytesWritable serializedSketch = (BytesWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(SKETCH_FIELD));
        state.update(HllSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch)));
    }

    private void initializeState(UnionState state, Object data) {
        int lgK = ((IntWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(LG_K_FIELD))).get();
        TgtHllType type = TgtHllType.valueOf((String)((Text)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(HLL_TYPE_FIELD))).toString());
        state.init(lgK, type);
    }

    public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        State state = (State)buf;
        if (state == null) {
            return null;
        }
        HllSketch result = state.getResult();
        if (result == null) {
            return null;
        }
        return new BytesWritable(result.toCompactByteArray());
    }

    public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        State state = (State)buf;
        state.reset();
    }
}

