/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.frequencies;

import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.frequencies.ItemsState;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;

abstract class ItemsEvaluator<T>
extends GenericUDAFEvaluator {
    private final ArrayOfItemsSerDe<T> serDe_;
    protected PrimitiveObjectInspector inputObjectInspector;

    ItemsEvaluator(ArrayOfItemsSerDe<T> serDe) {
        this.serDe_ = serDe;
    }

    public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
        super.init(mode, parameters);
        this.inputObjectInspector = (PrimitiveObjectInspector)parameters[0];
        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }

    public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        ItemsState state = (ItemsState)buf;
        state.reset();
    }

    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        return this.terminate(buf);
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object data) throws HiveException {
        if (data == null) {
            return;
        }
        ItemsState state = (ItemsState)buf;
        Memory serializedSketch = BytesWritableHelper.wrapAsMemory((BytesWritable)this.inputObjectInspector.getPrimitiveWritableObject(data));
        state.update(serializedSketch);
    }

    public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        ItemsState state = (ItemsState)buf;
        ItemsSketch resultSketch = state.getResult();
        if (resultSketch == null) {
            return null;
        }
        return new BytesWritable(resultSketch.toByteArray(this.serDe_));
    }

    public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new ItemsState<T>(this.serDe_);
    }
}

