/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.common.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import org.apache.cxf.dosgi.common.proxy.ExceptionMapper;

public class ServiceInvocationHandler
implements InvocationHandler {
    private static final Collection<Method> OBJECT_METHODS = Arrays.asList(Object.class.getMethods());
    private Object serviceObject;
    private ExceptionMapper exceptionMapper;

    ServiceInvocationHandler(Object serviceObject, Class<?> iType) {
        this.serviceObject = serviceObject;
        this.exceptionMapper = new ExceptionMapper(iType);
    }

    @Override
    public Object invoke(Object proxy, final Method m, Object[] params) throws Throwable {
        if (OBJECT_METHODS.contains(m)) {
            if (m.getName().equals("equals")) {
                params = new Object[]{Proxy.getInvocationHandler(params[0])};
            }
            return m.invoke((Object)this, params);
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            final Object[] paramsFinal = params;
            Object object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return m.invoke(ServiceInvocationHandler.this.serviceObject, paramsFinal);
                }
            });
            return object;
        }
        catch (Throwable ex) {
            Throwable theCause = ex.getCause() == null ? ex : ex.getCause();
            throw this.exceptionMapper.mapException(m, theCause);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

