/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.common.handlers;

import java.util.Collection;
import java.util.Map;
import org.apache.aries.rsa.spi.DistributionProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.dosgi.common.httpservice.HttpServiceManager;
import org.apache.cxf.dosgi.common.intent.IntentManager;
import org.apache.cxf.dosgi.common.util.PropertyHelper;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

public abstract class BaseDistributionProvider
implements DistributionProvider {
    protected IntentManager intentManager;
    protected HttpServiceManager httpServiceManager;

    protected boolean configTypeSupported(Map<String, Object> endpointProps, String configType) {
        Collection<String> configs = PropertyHelper.getMultiValueProperty(endpointProps.get("service.exported.configs"));
        return configs == null || configs.isEmpty() || configs.contains(configType);
    }

    protected EndpointDescription createEndpointDesc(Map<String, Object> props, String[] importedConfigs, String addressPropName, String address, Collection<String> intents) {
        props.put("service.imported.configs", importedConfigs);
        props.put(addressPropName, address);
        props.put("service.intents", intents);
        props.put("endpoint.id", address);
        return new EndpointDescription(props);
    }

    protected Bus createBus(Long sid, BundleContext callingContext, String contextRoot, Map<String, Object> endpointProps) {
        Bus bus = BusFactory.newInstance().createBus();
        for (Map.Entry<String, Object> prop : endpointProps.entrySet()) {
            if (!prop.getKey().startsWith("cxf.bus.prop.")) continue;
            bus.setProperty(prop.getKey().substring("cxf.bus.prop.".length()), prop.getValue());
        }
        if (contextRoot != null) {
            this.httpServiceManager.registerServlet(bus, contextRoot, callingContext, sid);
        }
        return bus;
    }

    protected void addContextProperties(AbstractEndpointFactory factory, Map<String, Object> sd, String propName) {
        Map props = (Map)sd.get(propName);
        if (props != null) {
            factory.getProperties(true).putAll(props);
        }
    }
}

