/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebServiceProvider;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.WrapperUtil;
import org.apache.cxf.tools.util.AnnotationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FrontendFactory {
    private static FrontendFactory instance;
    private Class serviceClass;
    private List<Method> wsMethods;
    private Class[] annotations = new Class[]{SOAPBinding.class, WebService.class, WebServiceProvider.class};

    private FrontendFactory() {
    }

    public static FrontendFactory getInstance() {
        if (instance == null) {
            instance = new FrontendFactory();
        }
        return instance;
    }

    private boolean isJaxws() {
        if (this.serviceClass == null) {
            return true;
        }
        for (Class annotation : this.annotations) {
            if (this.serviceClass.getAnnotation(annotation) == null) continue;
            return true;
        }
        return this.isJAXWSAnnotationExists();
    }

    private boolean isJAXWSAnnotationExists() {
        for (Method method : this.wsMethods) {
            if (WrapperUtil.isWrapperClassExists(method)) {
                return true;
            }
            WebParam param = (WebParam)AnnotationUtil.getPrivMethodAnnotation((Method)method, WebParam.class);
            if (param == null) continue;
            return true;
        }
        return false;
    }

    private List<Method> getWSMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.serviceClass.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || !Modifier.isPublic(method.getModifiers()) || this.isExcluced(method)) continue;
            methods.add(method);
        }
        return methods;
    }

    private boolean isExcluced(Method method) {
        WebMethod webMethod = (WebMethod)AnnotationUtil.getPrivMethodAnnotation((Method)method, WebMethod.class);
        return webMethod != null && webMethod.exclude();
    }

    public Style discoverStyle() {
        if (this.isJaxws()) {
            return Style.Jaxws;
        }
        return Style.Simple;
    }

    public void setServiceClass(Class c) {
        this.serviceClass = c;
        if (c != null) {
            this.wsMethods = this.getWSMethods();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        Jaxws,
        Simple;

    }
}

