/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.wss4j.common.principal.WSDerivedKeyTokenPrincipal;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.w3c.dom.Element;

public class AlgorithmSuitePolicyValidator
extends AbstractTokenPolicyValidator {
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "AlgorithmSuite");
        if (!ais.isEmpty()) {
            this.parsePolicies(aim, ais, message, results);
        }
        return true;
    }

    private void parsePolicies(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message, List<WSSecurityEngineResult> results) {
        for (AssertionInfo ai : ais) {
            AlgorithmSuite algorithmSuite = (AlgorithmSuite)ai.getAssertion();
            ai.setAsserted(true);
            boolean valid = this.validatePolicy(ai, algorithmSuite, results);
            if (valid) {
                String name;
                String namespace = algorithmSuite.getAlgorithmSuiteType().getNamespace();
                Collection algSuiteAis = (Collection)aim.get((Object)new QName(namespace, name = algorithmSuite.getAlgorithmSuiteType().getName()));
                if (algSuiteAis == null) continue;
                for (AssertionInfo algSuiteAi : algSuiteAis) {
                    algSuiteAi.setAsserted(true);
                }
                continue;
            }
            if (valid || !ai.isAsserted()) continue;
            ai.setNotAsserted("Error in validating AlgorithmSuite policy");
        }
    }

    public boolean validatePolicy(AssertionInfo ai, AlgorithmSuite algorithmPolicy, List<WSSecurityEngineResult> results) {
        boolean success = true;
        for (WSSecurityEngineResult result : results) {
            Integer actInt = (Integer)result.get((Object)"action");
            if (2 == actInt && !this.checkSignatureAlgorithms(result, algorithmPolicy, ai)) {
                success = false;
                continue;
            }
            if (4 != actInt || this.checkEncryptionAlgorithms(result, algorithmPolicy, ai)) continue;
            success = false;
        }
        return success;
    }

    private boolean checkSignatureAlgorithms(WSSecurityEngineResult result, AlgorithmSuite algorithmPolicy, AssertionInfo ai) {
        String signatureMethod = (String)result.get((Object)"signature-method");
        if (!algorithmPolicy.getAsymmetricSignature().equals(signatureMethod) && !algorithmPolicy.getSymmetricSignature().equals(signatureMethod)) {
            ai.setNotAsserted("The signature method does not match the requirement");
            return false;
        }
        String c14nMethod = (String)result.get((Object)"canonicalization-method");
        if (!algorithmPolicy.getC14n().getValue().equals(c14nMethod)) {
            ai.setNotAsserted("The c14n method does not match the requirement");
            return false;
        }
        List dataRefs = CastUtils.cast((List)((List)result.get((Object)"data-ref-uris")));
        if (!this.checkDataRefs(dataRefs, algorithmPolicy, ai)) {
            return false;
        }
        return this.checkKeyLengths(result, algorithmPolicy, ai, true);
    }

    private boolean checkDataRefs(List<WSDataRef> dataRefs, AlgorithmSuite algorithmPolicy, AssertionInfo ai) {
        AlgorithmSuite.AlgorithmSuiteType algorithmSuiteType = algorithmPolicy.getAlgorithmSuiteType();
        for (WSDataRef dataRef : dataRefs) {
            String digestMethod = dataRef.getDigestAlgorithm();
            if (!algorithmSuiteType.getDigest().equals(digestMethod)) {
                ai.setNotAsserted("The digest method does not match the requirement");
                return false;
            }
            List transformAlgorithms = dataRef.getTransformAlgorithms();
            if (transformAlgorithms == null || transformAlgorithms.size() > 2) {
                ai.setNotAsserted("The transform algorithms do not match the requirement");
                return false;
            }
            for (String transformAlgorithm : transformAlgorithms) {
                if (algorithmPolicy.getC14n().getValue().equals(transformAlgorithm) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(transformAlgorithm) || "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform".equals(transformAlgorithm) || "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete-Signature-Transform".equals(transformAlgorithm)) continue;
                ai.setNotAsserted("The transform algorithms do not match the requirement");
                return false;
            }
        }
        return true;
    }

    private boolean checkEncryptionAlgorithms(WSSecurityEngineResult result, AlgorithmSuite algorithmPolicy, AssertionInfo ai) {
        AlgorithmSuite.AlgorithmSuiteType algorithmSuiteType = algorithmPolicy.getAlgorithmSuiteType();
        String transportMethod = (String)result.get((Object)"encrypted-key-transport-method");
        if (transportMethod != null && !algorithmSuiteType.getSymmetricKeyWrap().equals(transportMethod) && !algorithmSuiteType.getAsymmetricKeyWrap().equals(transportMethod)) {
            ai.setNotAsserted("The Key transport method does not match the requirement");
            return false;
        }
        List dataRefs = CastUtils.cast((List)((List)result.get((Object)"data-ref-uris")));
        if (dataRefs != null) {
            for (WSDataRef dataRef : dataRefs) {
                String encryptionAlgorithm = dataRef.getAlgorithm();
                if (algorithmSuiteType.getEncryption().equals(encryptionAlgorithm)) continue;
                ai.setNotAsserted("The encryption algorithm does not match the requirement");
                return false;
            }
        }
        return this.checkKeyLengths(result, algorithmPolicy, ai, false);
    }

    private boolean checkKeyLengths(WSSecurityEngineResult result, AlgorithmSuite algorithmPolicy, AssertionInfo ai, boolean signature) {
        PublicKey publicKey = (PublicKey)result.get((Object)"public-key");
        if (publicKey != null && !this.checkPublicKeyLength(publicKey, algorithmPolicy, ai)) {
            return false;
        }
        X509Certificate x509Cert = (X509Certificate)result.get((Object)"x509-certificate");
        if (x509Cert != null && !this.checkPublicKeyLength(x509Cert.getPublicKey(), algorithmPolicy, ai)) {
            return false;
        }
        AlgorithmSuite.AlgorithmSuiteType algorithmSuiteType = algorithmPolicy.getAlgorithmSuiteType();
        byte[] secret = (byte[])result.get((Object)"secret");
        if (signature) {
            Principal principal = (Principal)result.get((Object)"principal");
            if (principal instanceof WSDerivedKeyTokenPrincipal) {
                int requiredLength = algorithmSuiteType.getSignatureDerivedKeyLength();
                if (secret == null || secret.length != requiredLength / 8) {
                    ai.setNotAsserted("The signature derived key length does not match the requirement");
                    return false;
                }
            } else if (secret != null && (secret.length < algorithmSuiteType.getMinimumSymmetricKeyLength() / 8 || secret.length > algorithmSuiteType.getMaximumSymmetricKeyLength() / 8)) {
                ai.setNotAsserted("The symmetric key length does not match the requirement");
                return false;
            }
        } else if (secret != null && (secret.length < algorithmSuiteType.getMinimumSymmetricKeyLength() / 8 || secret.length > algorithmSuiteType.getMaximumSymmetricKeyLength() / 8)) {
            ai.setNotAsserted("The symmetric key length does not match the requirement");
            return false;
        }
        return true;
    }

    private boolean checkPublicKeyLength(PublicKey publicKey, AlgorithmSuite algorithmPolicy, AssertionInfo ai) {
        AlgorithmSuite.AlgorithmSuiteType algorithmSuiteType = algorithmPolicy.getAlgorithmSuiteType();
        if (publicKey instanceof RSAPublicKey) {
            int modulus = ((RSAPublicKey)publicKey).getModulus().bitLength();
            if (modulus < algorithmSuiteType.getMinimumAsymmetricKeyLength() || modulus > algorithmSuiteType.getMaximumAsymmetricKeyLength()) {
                ai.setNotAsserted("The asymmetric key length does not match the requirement");
                return false;
            }
        } else if (publicKey instanceof DSAPublicKey) {
            int length = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
            if (length < algorithmSuiteType.getMinimumAsymmetricKeyLength() || length > algorithmSuiteType.getMaximumAsymmetricKeyLength()) {
                ai.setNotAsserted("The asymmetric key length does not match the requirement");
                return false;
            }
        } else {
            ai.setNotAsserted("An unknown public key was provided");
            return false;
        }
        return true;
    }
}

