/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.ContentEncryptedElements;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.KeyValueToken;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedElements;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.policy.model.Wss10;
import org.apache.cxf.ws.security.policy.model.Wss11;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStore;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.policyhandlers.WSSecurityTokenHolder;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecSignatureConfirmation;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBindingBuilder {
    public static final String CRYPTO_CACHE = "ws-security.crypto.cache";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractBindingBuilder.class);
    protected SPConstants.ProtectionOrder protectionOrder = SPConstants.ProtectionOrder.SignBeforeEncrypting;
    protected SOAPMessage saaj;
    protected WSSecHeader secHeader;
    protected AssertionInfoMap aim;
    protected Binding binding;
    protected SoapMessage message;
    protected WSSecTimestamp timestampEl;
    protected String mainSigId;
    protected Set<String> encryptedTokensIdList = new HashSet<String>();
    protected Map<Token, WSSecBase> endEncSuppTokMap;
    protected Map<Token, WSSecBase> endSuppTokMap;
    protected Map<Token, WSSecBase> sgndEndEncSuppTokMap;
    protected Map<Token, WSSecBase> sgndEndSuppTokMap;
    protected Vector<byte[]> signatures = new Vector();
    Element lastSupportingTokenElement;
    Element lastEncryptedKeyElement;
    Element lastDerivedKeyElement;
    Element bottomUpElement;
    Element topDownElement;

    public AbstractBindingBuilder(Binding binding, SOAPMessage saaj, WSSecHeader secHeader, AssertionInfoMap aim, SoapMessage message) {
        this.binding = binding;
        this.aim = aim;
        this.secHeader = secHeader;
        this.saaj = saaj;
        this.message = message;
        message.getExchange().put((Object)"_sendSignatureValues_", this.signatures);
    }

    private void insertAfter(Element child, Element sib) {
        if (sib.getNextSibling() == null) {
            this.secHeader.getSecurityHeader().appendChild(child);
        } else {
            this.secHeader.getSecurityHeader().insertBefore(child, sib.getNextSibling());
        }
    }

    protected void addDerivedKeyElement(Element el) {
        if (this.lastDerivedKeyElement != null) {
            this.insertAfter(el, this.lastDerivedKeyElement);
        } else if (this.lastEncryptedKeyElement != null) {
            this.insertAfter(el, this.lastEncryptedKeyElement);
        } else if (this.topDownElement != null) {
            this.insertAfter(el, this.topDownElement);
        } else if (this.secHeader.getSecurityHeader().getFirstChild() != null) {
            this.secHeader.getSecurityHeader().insertBefore(el, this.secHeader.getSecurityHeader().getFirstChild());
        } else {
            this.secHeader.getSecurityHeader().appendChild(el);
        }
        this.lastEncryptedKeyElement = el;
    }

    protected void addEncyptedKeyElement(Element el) {
        if (this.lastEncryptedKeyElement != null) {
            this.insertAfter(el, this.lastEncryptedKeyElement);
        } else if (this.lastDerivedKeyElement != null) {
            this.secHeader.getSecurityHeader().insertBefore(el, this.lastDerivedKeyElement);
        } else if (this.topDownElement != null) {
            this.insertAfter(el, this.topDownElement);
        } else if (this.secHeader.getSecurityHeader().getFirstChild() != null) {
            this.secHeader.getSecurityHeader().insertBefore(el, this.secHeader.getSecurityHeader().getFirstChild());
        } else {
            this.secHeader.getSecurityHeader().appendChild(el);
        }
        this.lastEncryptedKeyElement = el;
    }

    protected void addSupportingElement(Element el) {
        if (this.lastSupportingTokenElement != null) {
            this.insertAfter(el, this.lastSupportingTokenElement);
        } else if (this.lastDerivedKeyElement != null) {
            this.insertAfter(el, this.lastDerivedKeyElement);
        } else if (this.lastEncryptedKeyElement != null) {
            this.insertAfter(el, this.lastEncryptedKeyElement);
        } else if (this.topDownElement != null) {
            this.insertAfter(el, this.topDownElement);
        } else if (this.bottomUpElement != null) {
            this.secHeader.getSecurityHeader().insertBefore(el, this.bottomUpElement);
        } else {
            this.secHeader.getSecurityHeader().appendChild(el);
        }
        this.lastSupportingTokenElement = el;
    }

    protected void insertBeforeBottomUp(Element el) {
        if (this.bottomUpElement == null) {
            this.secHeader.getSecurityHeader().appendChild(el);
        } else {
            this.secHeader.getSecurityHeader().insertBefore(el, this.bottomUpElement);
        }
        this.bottomUpElement = el;
    }

    protected void addTopDownElement(Element el) {
        if (this.topDownElement == null) {
            if (this.secHeader.getSecurityHeader().getFirstChild() == null) {
                this.secHeader.getSecurityHeader().appendChild(el);
            } else {
                this.secHeader.getSecurityHeader().insertBefore(el, this.secHeader.getSecurityHeader().getFirstChild());
            }
        } else {
            this.insertAfter(el, this.topDownElement);
        }
        this.topDownElement = el;
    }

    protected boolean isRequestor() {
        return MessageUtils.isRequestor((Message)this.message);
    }

    protected void policyNotAsserted(PolicyAssertion assertion, Exception reason) {
        if (assertion == null) {
            return;
        }
        LOG.log(Level.FINE, "Not asserting " + assertion.getName() + ": " + reason);
        Collection ais = (Collection)this.aim.get((Object)assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason.getMessage());
            }
        }
        throw new PolicyException((Throwable)reason);
    }

    protected void policyNotAsserted(PolicyAssertion assertion, String reason) {
        if (assertion == null) {
            return;
        }
        LOG.log(Level.FINE, "Not asserting " + assertion.getName() + ": " + reason);
        Collection ais = (Collection)this.aim.get((Object)assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason);
            }
        }
        if (!assertion.isOptional()) {
            throw new PolicyException(new org.apache.cxf.common.i18n.Message(reason, LOG, new Object[0]));
        }
    }

    protected void policyAsserted(PolicyAssertion assertion) {
        if (assertion == null) {
            return;
        }
        LOG.log(Level.FINE, "Asserting " + assertion.getName());
        Collection ais = (Collection)this.aim.get((Object)assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setAsserted(true);
            }
        }
    }

    protected void policyAsserted(QName n) {
        Collection ais = this.aim.getAssertionInfo(n);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
    }

    protected Collection<PolicyAssertion> findAndAssertPolicy(QName n) {
        Collection ais = this.aim.getAssertionInfo(n);
        if (ais != null && !ais.isEmpty()) {
            ArrayList<PolicyAssertion> p = new ArrayList<PolicyAssertion>(ais.size());
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
                p.add(ai.getAssertion());
            }
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<Object, Crypto> getCryptoCache() {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = ((Endpoint)this.message.getExchange().get(Endpoint.class)).getEndpointInfo();
        synchronized (endpointInfo) {
            ConcurrentHashMap<Object, Crypto> o = CastUtils.cast((Map)((Map)this.message.getContextualProperty(CRYPTO_CACHE)));
            if (o == null) {
                o = new ConcurrentHashMap<Object, Crypto>();
                info.setProperty(CRYPTO_CACHE, o);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TokenStore getTokenStore() {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = ((Endpoint)this.message.getExchange().get(Endpoint.class)).getEndpointInfo();
        synchronized (endpointInfo) {
            TokenStore tokenStore = (TokenStore)this.message.getContextualProperty(TokenStore.class.getName());
            if (tokenStore == null) {
                tokenStore = (TokenStore)info.getProperty(TokenStore.class.getName());
            }
            if (tokenStore == null) {
                tokenStore = new MemoryTokenStore();
                info.setProperty(TokenStore.class.getName(), (Object)tokenStore);
            }
            return tokenStore;
        }
    }

    protected WSSecTimestamp createTimestamp() {
        Collection ais = (Collection)this.aim.get((Object)SP12Constants.INCLUDE_TIMESTAMP);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                this.timestampEl = new WSSecTimestamp();
                Object o = this.message.getContextualProperty("ws-security.timestamp.timeToLive");
                int ttl = 300;
                if (o instanceof Number) {
                    ttl = ((Number)o).intValue();
                } else if (o instanceof String) {
                    ttl = Integer.parseInt((String)o);
                }
                if (ttl <= 0) {
                    ttl = 300;
                }
                this.timestampEl.setTimeToLive(ttl);
                this.timestampEl.prepare((Document)this.saaj.getSOAPPart());
                ai.setAsserted(true);
            }
        }
        return this.timestampEl;
    }

    protected WSSecTimestamp handleLayout(WSSecTimestamp timestamp) {
        Collection ais = (Collection)this.aim.get((Object)SP12Constants.LAYOUT);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                Layout layout = (Layout)ai.getAssertion();
                ai.setAsserted(true);
                if (SPConstants.Layout.LaxTimestampLast == layout.getValue()) {
                    if (timestamp == null) {
                        ai.setNotAsserted((Object)((Object)SPConstants.Layout.LaxTimestampLast) + " requires a timestamp");
                        continue;
                    }
                    ai.setAsserted(true);
                    Element el = timestamp.getElement();
                    this.secHeader.getSecurityHeader().appendChild(el);
                    if (this.bottomUpElement != null) continue;
                    this.bottomUpElement = el;
                    continue;
                }
                if (SPConstants.Layout.LaxTimestampFirst == layout.getValue()) {
                    if (timestamp == null) {
                        ai.setNotAsserted((Object)((Object)SPConstants.Layout.LaxTimestampLast) + " requires a timestamp");
                        continue;
                    }
                    this.addTopDownElement(this.timestampEl.getElement());
                    continue;
                }
                if (this.timestampEl == null) continue;
                this.addTopDownElement(this.timestampEl.getElement());
            }
        } else if (this.timestampEl != null) {
            this.addTopDownElement(this.timestampEl.getElement());
        }
        return timestamp;
    }

    protected void assertSupportingTokens(Collection<PolicyAssertion> suppTokens) {
        if (suppTokens == null) {
            return;
        }
        for (PolicyAssertion pa : suppTokens) {
            if (!(pa instanceof SupportingToken)) continue;
            for (Token token : ((SupportingToken)pa).getTokens()) {
                this.policyAsserted(token);
            }
        }
    }

    protected Map<Token, WSSecBase> handleSupportingTokens(Collection<PolicyAssertion> tokens, boolean endorse) {
        HashMap<Token, WSSecBase> ret = new HashMap<Token, WSSecBase>();
        if (tokens != null) {
            for (PolicyAssertion pa : tokens) {
                if (!(pa instanceof SupportingToken)) continue;
                this.handleSupportingTokens((SupportingToken)pa, endorse, ret);
            }
        }
        return ret;
    }

    protected Map<Token, WSSecBase> handleSupportingTokens(SupportingToken suppTokens, boolean endorse) {
        return this.handleSupportingTokens(suppTokens, endorse, new HashMap<Token, WSSecBase>());
    }

    protected Map<Token, WSSecBase> handleSupportingTokens(SupportingToken suppTokens, boolean endorse, Map<Token, WSSecBase> ret) {
        if (suppTokens == null) {
            return ret;
        }
        for (Token token : suppTokens.getTokens()) {
            WSSecSignatureHelper sig;
            if (token instanceof UsernameToken) {
                WSSecUsernameToken utBuilder = this.addUsernameToken((UsernameToken)token);
                if (utBuilder == null) continue;
                utBuilder.prepare((Document)this.saaj.getSOAPPart());
                this.addSupportingElement(utBuilder.getUsernameTokenElement());
                ret.put(token, (WSSecBase)utBuilder);
                if (!suppTokens.isEncryptedToken() && !MessageUtils.getContextualBoolean((Message)this.message, (String)"ws-security.username-token.always.encrypted", (boolean)true)) continue;
                this.encryptedTokensIdList.add(utBuilder.getId());
                continue;
            }
            if (this.isRequestor() && (token instanceof IssuedToken || token instanceof SecureConversationToken)) {
                SecurityToken secToken = this.getSecurityToken();
                if (secToken == null) {
                    this.policyNotAsserted((PolicyAssertion)token, "Could not find IssuedToken");
                }
                this.addSupportingElement(this.cloneElement(secToken.getToken()));
                if (suppTokens.isEncryptedToken()) {
                    this.encryptedTokensIdList.add(secToken.getId());
                }
                if (secToken.getX509Certificate() == null) {
                    ret.put(token, new WSSecurityTokenHolder(secToken));
                    continue;
                }
                WSSecSignatureHelper sig2 = new WSSecSignatureHelper();
                sig2.setX509Certificate(secToken.getX509Certificate());
                sig2.setCustomTokenId(secToken.getId());
                sig2.setKeyIdentifierType(12);
                if (secToken.getTokenType() == null) {
                    sig2.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                } else {
                    sig2.setCustomTokenValueType(secToken.getTokenType());
                }
                sig2.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getAsymmetricSignature());
                sig2.setSigCanonicalization(this.binding.getAlgorithmSuite().getInclusiveC14n());
                Crypto crypto = secToken.getCrypto();
                String uname = null;
                try {
                    uname = crypto.getKeyStore().getCertificateAlias(secToken.getX509Certificate());
                }
                catch (KeyStoreException e1) {
                    throw new Fault((Throwable)e1);
                }
                String password = this.getPassword(uname, token, 3);
                if (password == null) {
                    password = "";
                }
                sig2.setUserInfo(uname, password);
                try {
                    sig2.prepare((Document)this.saaj.getSOAPPart(), secToken.getCrypto(), this.secHeader);
                }
                catch (WSSecurityException e) {
                    throw new Fault((Throwable)e);
                }
                if (suppTokens.isEncryptedToken()) {
                    this.encryptedTokensIdList.add(secToken.getId());
                }
                ret.put(token, (WSSecBase)sig2);
                continue;
            }
            if (token instanceof X509Token) {
                sig = this.getSignatureBuider(suppTokens, token, endorse);
                Element bstElem = sig.getBinarySecurityTokenElement();
                if (bstElem != null) {
                    sig.prependBSTElementToHeader(this.secHeader);
                }
                if (suppTokens.isEncryptedToken()) {
                    this.encryptedTokensIdList.add(sig.getBSTTokenId());
                }
                ret.put(token, (WSSecBase)sig);
                continue;
            }
            if (!(token instanceof KeyValueToken)) continue;
            sig = this.getSignatureBuider(suppTokens, token, endorse);
            if (suppTokens.isEncryptedToken()) {
                this.encryptedTokensIdList.add(sig.getBSTTokenId());
            }
            ret.put(token, (WSSecBase)sig);
        }
        return ret;
    }

    protected Element cloneElement(Element el) {
        return (Element)this.secHeader.getSecurityHeader().getOwnerDocument().importNode(el, true);
    }

    protected SecurityToken getSecurityToken() {
        String id;
        SecurityToken st = (SecurityToken)this.message.getContextualProperty("ws-security.token");
        if (st == null && (id = (String)this.message.getContextualProperty("ws-security.token.id")) != null) {
            st = this.getTokenStore().getToken(id);
        }
        this.getTokenStore().add(st);
        return st;
    }

    protected void addSignatureParts(Map<Token, WSSecBase> tokenMap, List<WSEncryptionPart> sigParts) {
        for (Map.Entry<Token, WSSecBase> entry : tokenMap.entrySet()) {
            WSSecBase tempTok = entry.getValue();
            WSEncryptionPart part = null;
            if (tempTok instanceof WSSecSignatureHelper) {
                WSSecSignatureHelper tempSig = (WSSecSignatureHelper)tempTok;
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(tempSig.getSecRef().getKeyIdentifierValueType())) {
                    this.addSupportingElement(this.cloneElement(tempSig.getSecRef().getElement()));
                    part = new WSEncryptionPart(tempSig.getStrUri(), "ExternalSTRTransform", "Element", 3);
                } else if (tempSig.getBSTTokenId() != null) {
                    part = new WSEncryptionPart(tempSig.getBSTTokenId());
                }
            } else if (tempTok instanceof WSSecUsernameToken) {
                WSSecUsernameToken unt = (WSSecUsernameToken)tempTok;
                part = new WSEncryptionPart(unt.getId());
            } else {
                this.policyNotAsserted((PolicyAssertion)entry.getKey(), "UnsupportedTokenInSupportingToken: " + tempTok);
            }
            if (part == null) continue;
            sigParts.add(part);
        }
    }

    protected WSSecUsernameToken addUsernameToken(UsernameToken token) {
        AssertionInfo info = null;
        Collection ais = this.aim.getAssertionInfo(token.getName());
        for (AssertionInfo ai : ais) {
            if (ai.getAssertion() != token) continue;
            info = ai;
            if (this.isRequestor()) continue;
            info.setAsserted(true);
            return null;
        }
        String userName = (String)this.message.getContextualProperty("ws-security.username");
        if (!StringUtils.isEmpty((String)userName)) {
            if (token.isNoPassword()) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken();
                utBuilder.setUserInfo(userName, null);
                utBuilder.setPasswordType(null);
                info.setAsserted(true);
                return utBuilder;
            }
            String password = (String)this.message.getContextualProperty("ws-security.password");
            if (StringUtils.isEmpty((String)password)) {
                password = this.getPassword(userName, token, 2);
            }
            if (!StringUtils.isEmpty((String)password)) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken();
                if (token.isHashPassword()) {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                } else {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                }
                utBuilder.setUserInfo(userName, password);
                info.setAsserted(true);
                return utBuilder;
            }
            this.policyNotAsserted((PolicyAssertion)token, "No username available");
        } else {
            this.policyNotAsserted((PolicyAssertion)token, "No username available");
        }
        return null;
    }

    public String getPassword(String userName, PolicyAssertion info, int type) {
        Object o = this.message.getContextualProperty("ws-security.callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), this.getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        if (handler == null) {
            this.policyNotAsserted(info, "No callback handler and no password available");
            return null;
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(userName, type)};
        try {
            handler.handle((Callback[])cb);
        }
        catch (Exception e) {
            this.policyNotAsserted(info, e);
        }
        return cb[0].getPassword();
    }

    public String addWsuIdToElement(Element elem) {
        String id;
        Attr idAttr = elem.getAttributeNode("Id");
        if (idAttr == null) {
            idAttr = elem.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        if (idAttr != null) {
            id = idAttr.getValue();
        } else {
            id = "Id-" + elem.hashCode();
            String pfx = elem.lookupPrefix("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            boolean found = !StringUtils.isEmpty((String)pfx);
            int cnt = 0;
            while (StringUtils.isEmpty((String)pfx)) {
                pfx = "wsu" + (cnt == 0 ? "" : Integer.valueOf(cnt));
                if (StringUtils.isEmpty((String)elem.lookupNamespaceURI(pfx))) continue;
                pfx = null;
                ++cnt;
            }
            if (!found) {
                idAttr = elem.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + pfx);
                idAttr.setValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                elem.setAttributeNodeNS(idAttr);
            }
            idAttr = elem.getOwnerDocument().createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", pfx + ":Id");
            idAttr.setValue(id);
            elem.setAttributeNodeNS(idAttr);
        }
        return id;
    }

    public Vector<WSEncryptionPart> getEncryptedParts() throws SOAPException {
        boolean isBody = false;
        SignedEncryptedParts parts = null;
        SignedEncryptedElements elements = null;
        ContentEncryptedElements celements = null;
        Collection ais = this.aim.getAssertionInfo(SP12Constants.ENCRYPTED_PARTS);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                parts = (SignedEncryptedParts)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        if ((ais = this.aim.getAssertionInfo(SP12Constants.ENCRYPTED_ELEMENTS)) != null) {
            for (AssertionInfo ai : ais) {
                elements = (SignedEncryptedElements)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        if ((ais = this.aim.getAssertionInfo(SP12Constants.CONTENT_ENCRYPTED_ELEMENTS)) != null) {
            for (AssertionInfo ai : ais) {
                celements = (ContentEncryptedElements)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        ArrayList<WSEncryptionPart> signedParts = new ArrayList<WSEncryptionPart>();
        if (parts != null) {
            isBody = parts.isBody();
            for (Header head : parts.getHeaders()) {
                WSEncryptionPart wep = new WSEncryptionPart(head.getName(), head.getNamespace(), "Element");
                signedParts.add(wep);
            }
        }
        return this.getPartsAndElements(false, isBody, signedParts, elements == null ? null : elements.getXPathExpressions(), elements == null ? null : elements.getDeclaredNamespaces(), celements == null ? null : celements.getXPathExpressions(), celements == null ? null : celements.getDeclaredNamespaces());
    }

    public Vector<WSEncryptionPart> getSignedParts() throws SOAPException {
        boolean isSignBody = false;
        SignedEncryptedParts parts = null;
        SignedEncryptedElements elements = null;
        Collection ais = this.aim.getAssertionInfo(SP12Constants.SIGNED_PARTS);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                parts = (SignedEncryptedParts)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        if ((ais = this.aim.getAssertionInfo(SP12Constants.SIGNED_ELEMENTS)) != null) {
            for (AssertionInfo ai : ais) {
                elements = (SignedEncryptedElements)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        ArrayList<WSEncryptionPart> signedParts = new ArrayList<WSEncryptionPart>();
        if (parts != null) {
            isSignBody = parts.isBody();
            for (Header head : parts.getHeaders()) {
                WSEncryptionPart wep = new WSEncryptionPart(head.getName(), head.getNamespace(), "Element");
                signedParts.add(wep);
            }
        }
        return this.getPartsAndElements(true, isSignBody, signedParts, elements == null ? null : elements.getXPathExpressions(), elements == null ? null : elements.getDeclaredNamespaces(), null, null);
    }

    public Vector<WSEncryptionPart> getPartsAndElements(boolean sign, boolean includeBody, List<WSEncryptionPart> parts, List<String> xpaths, Map<String, String> namespaces, List<String> contentXpaths, Map<String, String> cnamespaces) throws SOAPException {
        Vector<WSEncryptionPart> result = new Vector<WSEncryptionPart>();
        ArrayList<Element> found = new ArrayList<Element>();
        result.addAll(this.getParts(sign, includeBody, parts, found));
        try {
            result.addAll(this.getElements("Element", xpaths, namespaces, found));
        }
        catch (XPathExpressionException e) {
            // empty catch block
        }
        try {
            result.addAll(this.getElements("Content", contentXpaths, cnamespaces, found));
        }
        catch (XPathExpressionException e) {
            // empty catch block
        }
        return result;
    }

    private Vector<WSEncryptionPart> getParts(boolean sign, boolean includeBody, List<WSEncryptionPart> parts, List<Element> found) throws SOAPException {
        Vector<WSEncryptionPart> result = new Vector<WSEncryptionPart>();
        if (includeBody && !found.contains(this.saaj.getSOAPBody())) {
            found.add((Element)this.saaj.getSOAPBody());
            String id = this.addWsuIdToElement((Element)this.saaj.getSOAPBody());
            if (sign) {
                result.add(new WSEncryptionPart(id, "Element", 2));
            } else {
                result.add(new WSEncryptionPart(id, "Content", 2));
            }
        }
        SOAPHeader header = this.saaj.getSOAPHeader();
        for (WSEncryptionPart part : parts) {
            List elements = StringUtils.isEmpty((String)part.getName()) ? DOMUtils.getChildrenWithNamespace((Element)header, (String)part.getNamespace()) : DOMUtils.getChildrenWithName((Element)header, (String)part.getNamespace(), (String)part.getName());
            for (Element el : elements) {
                if (found.contains(el)) continue;
                found.add(el);
                String id = this.addWsuIdToElement(el);
                result.add(new WSEncryptionPart(id, part.getEncModifier(), 1));
            }
        }
        return result;
    }

    private Vector<WSEncryptionPart> getElements(String encryptionModifier, List<String> xpaths, Map<String, String> namespaces, List<Element> found) throws XPathExpressionException, SOAPException {
        Vector<WSEncryptionPart> result = new Vector<WSEncryptionPart>();
        if (xpaths != null && !xpaths.isEmpty()) {
            XPathFactory factory = XPathFactory.newInstance();
            for (String expression : xpaths) {
                XPath xpath = factory.newXPath();
                if (namespaces != null) {
                    xpath.setNamespaceContext((NamespaceContext)new MapNamespaceContext(namespaces));
                }
                NodeList list = (NodeList)xpath.evaluate(expression, this.saaj.getSOAPPart().getEnvelope(), XPathConstants.NODESET);
                for (int x = 0; x < list.getLength(); ++x) {
                    Element el = (Element)list.item(x);
                    if (found.contains(el)) continue;
                    String id = this.addWsuIdToElement(el);
                    WSEncryptionPart part = new WSEncryptionPart(id, encryptionModifier, 3);
                    part.setXpath(expression);
                    result.add(part);
                }
            }
        }
        return result;
    }

    protected WSSecEncryptedKey getEncryptedKeyBuilder(TokenWrapper wrapper, Token token) throws WSSecurityException {
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey();
        Crypto crypto = this.getEncryptionCrypto(wrapper);
        this.message.getExchange().put((Object)"ws-security.encryption.crypto", (Object)crypto);
        this.setKeyIdentifierType((WSSecBase)encrKey, wrapper, token);
        this.setEncryptionUser(encrKey, wrapper, false, crypto);
        encrKey.setKeySize(this.binding.getAlgorithmSuite().getMaximumSymmetricKeyLength());
        encrKey.setKeyEncAlgo(this.binding.getAlgorithmSuite().getAsymmetricKeyWrap());
        encrKey.prepare((Document)this.saaj.getSOAPPart(), crypto);
        return encrKey;
    }

    public Crypto getSignatureCrypto(TokenWrapper wrapper) {
        return this.getCrypto(wrapper, "ws-security.signature.crypto", "ws-security.signature.properties");
    }

    public Crypto getEncryptionCrypto(TokenWrapper wrapper) {
        return this.getCrypto(wrapper, "ws-security.encryption.crypto", "ws-security.encryption.properties");
    }

    public Crypto getCrypto(TokenWrapper wrapper, String cryptoKey, String propKey) {
        Properties properties;
        Object o;
        Crypto crypto;
        block15: {
            crypto = (Crypto)this.message.getContextualProperty(cryptoKey);
            if (crypto != null) {
                return crypto;
            }
            o = this.message.getContextualProperty(propKey);
            if (o == null) {
                return null;
            }
            crypto = this.getCryptoCache().get(o);
            if (crypto != null) {
                return crypto;
            }
            properties = null;
            if (o instanceof Properties) {
                properties = (Properties)o;
            } else if (o instanceof String) {
                ResourceManager rm = (ResourceManager)((Bus)this.message.getExchange().get(Bus.class)).getExtension(ResourceManager.class);
                URL url = (URL)rm.resolveResource((String)o, URL.class);
                try {
                    if (url == null) {
                        url = ClassLoaderUtils.getResource((String)((String)o), this.getClass());
                    }
                    if (url != null) {
                        InputStream ins = url.openStream();
                        properties = new Properties();
                        properties.load(ins);
                        ins.close();
                        break block15;
                    }
                    this.policyNotAsserted((PolicyAssertion)wrapper, "Could not find properties file " + o);
                }
                catch (IOException e) {
                    this.policyNotAsserted((PolicyAssertion)wrapper, e);
                }
            } else if (o instanceof URL) {
                properties = new Properties();
                try {
                    InputStream ins = ((URL)o).openStream();
                    properties.load(ins);
                    ins.close();
                }
                catch (IOException e) {
                    this.policyNotAsserted((PolicyAssertion)wrapper, e);
                }
            }
        }
        if (properties != null) {
            crypto = CryptoFactory.getInstance((Properties)properties);
            this.getCryptoCache().put(o, crypto);
        }
        return crypto;
    }

    public void setKeyIdentifierType(WSSecBase secBase, TokenWrapper wrapper, Token token) {
        if (token.getInclusion() == SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER) {
            boolean tokenTypeSet = false;
            if (token instanceof X509Token) {
                X509Token x509Token = (X509Token)token;
                if (x509Token.isRequireIssuerSerialReference()) {
                    secBase.setKeyIdentifierType(2);
                    tokenTypeSet = true;
                } else if (x509Token.isRequireKeyIdentifierReference()) {
                    secBase.setKeyIdentifierType(4);
                    tokenTypeSet = true;
                } else if (x509Token.isRequireThumbprintReference()) {
                    secBase.setKeyIdentifierType(8);
                    tokenTypeSet = true;
                }
            } else if (token instanceof KeyValueToken) {
                secBase.setKeyIdentifierType(13);
                tokenTypeSet = true;
            }
            if (!tokenTypeSet) {
                this.policyAsserted(token);
                this.policyAsserted(wrapper);
                Wss10 wss = this.getWss10();
                this.policyAsserted(wss);
                if (wss.isMustSupportRefKeyIdentifier()) {
                    secBase.setKeyIdentifierType(4);
                } else if (wss.isMustSupportRefIssuerSerial()) {
                    secBase.setKeyIdentifierType(2);
                } else if (wss instanceof Wss11 && ((Wss11)wss).isMustSupportRefThumbprint()) {
                    secBase.setKeyIdentifierType(8);
                }
            }
        } else {
            this.policyAsserted(token);
            this.policyAsserted(wrapper);
            secBase.setKeyIdentifierType(1);
        }
    }

    public void setEncryptionUser(WSSecEncryptedKey encrKeyBuilder, TokenWrapper token, boolean sign, Crypto crypto) {
        String encrUser = (String)this.message.getContextualProperty(sign ? "ws-security.signature.username" : "ws-security.encryption.username");
        if (crypto != null) {
            if (encrUser == null) {
                encrUser = crypto.getDefaultX509Alias();
            }
            if (encrUser == null) {
                try {
                    Enumeration<String> en = crypto.getKeyStore().aliases();
                    if (en.hasMoreElements()) {
                        encrUser = en.nextElement();
                    }
                    if (en.hasMoreElements()) {
                        encrUser = null;
                    }
                }
                catch (KeyStoreException e) {}
            }
        } else if (encrUser == null || "".equals(encrUser)) {
            this.policyNotAsserted((PolicyAssertion)token, "No " + (sign ? "signature" : "encryption") + " crypto object found.");
        }
        if (encrUser == null || "".equals(encrUser)) {
            this.policyNotAsserted((PolicyAssertion)token, "No " + (sign ? "signature" : "encryption") + " username found.");
        }
        if ("useReqSigCert".equals(encrUser)) {
            Object resultsObj = this.message.getExchange().getInMessage().get((Object)"RECV_RESULTS");
            if (resultsObj != null) {
                encrKeyBuilder.setUseThisCert(AbstractBindingBuilder.getReqSigCert((Vector)resultsObj));
                if (encrKeyBuilder.isCertSet()) {
                    encrKeyBuilder.setUserInfo(AbstractBindingBuilder.getUsername((Vector)resultsObj));
                }
            } else {
                this.policyNotAsserted((PolicyAssertion)token, "No security results in incoming message");
            }
        } else {
            encrKeyBuilder.setUserInfo(encrUser);
        }
    }

    private static X509Certificate getReqSigCert(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 2) continue;
                return (X509Certificate)wser.get((Object)"x509-certificate");
            }
        }
        return null;
    }

    public static String getUsername(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 1) continue;
                WSUsernameTokenPrincipal principal = (WSUsernameTokenPrincipal)wser.get((Object)"principal");
                return principal.getName();
            }
        }
        return null;
    }

    protected Wss10 getWss10() {
        Iterator i$;
        Collection ais = this.aim.getAssertionInfo(SP12Constants.WSS10);
        if (ais != null && (i$ = ais.iterator()).hasNext()) {
            AssertionInfo ai = (AssertionInfo)i$.next();
            return (Wss10)ai.getAssertion();
        }
        ais = this.aim.getAssertionInfo(SP12Constants.WSS11);
        if (ais != null && (i$ = ais.iterator()).hasNext()) {
            AssertionInfo ai = (AssertionInfo)i$.next();
            return (Wss10)ai.getAssertion();
        }
        return null;
    }

    private void checkForX509PkiPath(WSSecSignature sig, Token token) {
        X509Token x509Token;
        if (token instanceof X509Token && ((x509Token = (X509Token)token).getTokenVersionAndType().equals("WssX509PkiPathV1Token10") || x509Token.getTokenVersionAndType().equals("WssX509PkiPathV1Token11"))) {
            sig.setUseSingleCertificate(false);
        }
    }

    protected WSSecSignatureHelper getSignatureBuider(TokenWrapper wrapper, Token token, boolean endorse) {
        Crypto crypto;
        WSSecSignatureHelper sig = new WSSecSignatureHelper();
        this.checkForX509PkiPath(sig, token);
        this.setKeyIdentifierType((WSSecBase)sig, wrapper, token);
        boolean encryptCrypto = false;
        String userNameKey = "ws-security.signature.username";
        String type = "signature";
        if (this.binding instanceof SymmetricBinding && !endorse) {
            encryptCrypto = ((SymmetricBinding)this.binding).getProtectionToken() != null;
            userNameKey = "ws-security.encryption.username";
        }
        Crypto crypto2 = crypto = encryptCrypto ? this.getEncryptionCrypto(wrapper) : this.getSignatureCrypto(wrapper);
        if (endorse && crypto == null && this.binding instanceof SymmetricBinding) {
            userNameKey = "ws-security.encryption.username";
            crypto = this.getEncryptionCrypto(wrapper);
        }
        if (!endorse) {
            this.message.getExchange().put((Object)"ws-security.signature.crypto", (Object)crypto);
        }
        String user = (String)this.message.getContextualProperty(userNameKey);
        if (crypto != null) {
            if (StringUtils.isEmpty((String)user)) {
                user = crypto.getDefaultX509Alias();
            }
            if (user == null) {
                try {
                    Enumeration<String> en = crypto.getKeyStore().aliases();
                    if (en.hasMoreElements()) {
                        user = en.nextElement();
                    }
                    if (en.hasMoreElements()) {
                        user = null;
                    }
                }
                catch (KeyStoreException e) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isEmpty((String)user)) {
            this.policyNotAsserted((PolicyAssertion)token, "No " + type + " username found.");
            return null;
        }
        String password = this.getPassword(user, token, 3);
        if (password == null) {
            password = "";
        }
        sig.setUserInfo(user, password);
        sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getAsymmetricSignature());
        sig.setDigestAlgo(this.binding.getAlgorithmSuite().getDigest());
        sig.setSigCanonicalization(this.binding.getAlgorithmSuite().getInclusiveC14n());
        try {
            sig.prepare((Document)this.saaj.getSOAPPart(), crypto, this.secHeader);
        }
        catch (WSSecurityException e) {
            this.policyNotAsserted((PolicyAssertion)token, (Exception)((Object)e));
        }
        return sig;
    }

    protected void doEndorsedSignatures(Map<Token, WSSecBase> tokenMap, boolean isTokenProtection, boolean isSigProtect) {
        for (Map.Entry<Token, WSSecBase> ent : tokenMap.entrySet()) {
            WSSecBase tempTok = ent.getValue();
            Vector<WSEncryptionPart> sigParts = new Vector<WSEncryptionPart>();
            sigParts.add(new WSEncryptionPart(this.mainSigId));
            if (tempTok instanceof WSSecSignature) {
                WSSecSignature sig = (WSSecSignature)tempTok;
                if (isTokenProtection && sig.getBSTTokenId() != null) {
                    sigParts.add(new WSEncryptionPart(sig.getBSTTokenId()));
                }
                try {
                    sig.addReferencesToSign(sigParts, this.secHeader);
                    sig.computeSignature();
                    sig.appendToHeader(this.secHeader);
                    this.signatures.add(sig.getSignatureValue());
                    if (!isSigProtect) continue;
                    this.encryptedTokensIdList.add(sig.getId());
                }
                catch (WSSecurityException e) {
                    this.policyNotAsserted((PolicyAssertion)ent.getKey(), (Exception)((Object)e));
                }
                continue;
            }
            if (!(tempTok instanceof WSSecurityTokenHolder)) continue;
            SecurityToken token = ((WSSecurityTokenHolder)tempTok).getToken();
            if (isTokenProtection) {
                sigParts.add(new WSEncryptionPart(token.getId()));
            }
            try {
                if (ent.getKey().isDerivedKeys()) {
                    this.doSymmSignatureDerived(ent.getKey(), token, sigParts, isTokenProtection);
                    continue;
                }
                this.doSymmSignature(ent.getKey(), token, sigParts, isTokenProtection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void doSymmSignatureDerived(Token policyToken, SecurityToken tok, Vector<WSEncryptionPart> sigParts, boolean isTokenProtection) throws WSSecurityException, ConversationException {
        Element ref;
        SOAPPart doc = this.saaj.getSOAPPart();
        WSSecDKSign dkSign = new WSSecDKSign();
        if (SP12Constants.INSTANCE == policyToken.getSPConstants()) {
            dkSign.setWscVersion(2);
        }
        boolean attached = false;
        if (SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS == policyToken.getInclusion() || SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE == policyToken.getInclusion() || this.isRequestor() && SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT == policyToken.getInclusion()) {
            attached = true;
        }
        if ((ref = attached ? tok.getAttachedReference() : tok.getUnattachedReference()) != null) {
            ref = this.cloneElement(ref);
            dkSign.setExternalKey(tok.getSecret(), ref);
        } else if (!this.isRequestor() && policyToken.isDerivedKeys()) {
            SecurityTokenReference tokenRef = new SecurityTokenReference((Document)doc);
            if (tok.getSHA1() != null) {
                tokenRef.setKeyIdentifierEncKeySHA1(tok.getSHA1());
            }
            dkSign.setExternalKey(tok.getSecret(), tokenRef.getElement());
        } else {
            dkSign.setExternalKey(tok.getSecret(), tok.getId());
        }
        dkSign.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getSymmetricSignature());
        dkSign.setDerivedKeyLength(this.binding.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
        if (tok.getSHA1() != null) {
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        }
        dkSign.prepare((Document)doc, this.secHeader);
        if (isTokenProtection) {
            String sigTokId = tok.getId();
            if (sigTokId.startsWith("#")) {
                sigTokId = sigTokId.substring(1);
            }
            sigParts.add(new WSEncryptionPart(sigTokId));
        }
        dkSign.setParts(sigParts);
        dkSign.addReferencesToSign(sigParts, this.secHeader);
        dkSign.computeSignature();
        this.addSupportingElement(dkSign.getdktElement());
        this.secHeader.getSecurityHeader().appendChild(dkSign.getSignatureElement());
        this.signatures.add(dkSign.getSignatureValue());
    }

    private void doSymmSignature(Token policyToken, SecurityToken tok, Vector<WSEncryptionPart> sigParts, boolean isTokenProtection) throws WSSecurityException, ConversationException {
        SOAPPart doc = this.saaj.getSOAPPart();
        WSSecSignature sig = new WSSecSignature();
        if (policyToken instanceof X509Token) {
            if (this.isRequestor()) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                sig.setKeyIdentifierType(9);
            } else {
                sig.setEncrKeySha1value(tok.getSHA1());
                sig.setKeyIdentifierType(10);
            }
        } else {
            if (tok.getTokenType() != null) {
                sig.setCustomTokenValueType(tok.getTokenType());
            } else {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
            }
            sig.setKeyIdentifierType(9);
        }
        String sigTokId = tok.getWsuId();
        if (sigTokId == null) {
            sigTokId = tok.getId();
        }
        if (sigTokId.startsWith("#")) {
            sigTokId = sigTokId.substring(1);
        }
        sig.setCustomTokenId(sigTokId);
        sig.setSecretKey(tok.getSecret());
        sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getAsymmetricSignature());
        sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getSymmetricSignature());
        sig.prepare((Document)doc, this.getSignatureCrypto(null), this.secHeader);
        sig.setParts(sigParts);
        sig.addReferencesToSign(sigParts, this.secHeader);
        sig.computeSignature();
        this.signatures.add(sig.getSignatureValue());
        this.secHeader.getSecurityHeader().appendChild(sig.getSignatureElement());
    }

    protected void assertSupportingTokens(Vector<WSEncryptionPart> sigs) {
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SIGNED_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.ENDORSING_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.ENCRYPTED_SUPPORTING_TOKENS));
    }

    protected void addSupportingTokens(Vector<WSEncryptionPart> sigs) {
        Collection<PolicyAssertion> sgndSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_SUPPORTING_TOKENS);
        Map<Token, WSSecBase> sigSuppTokMap = this.handleSupportingTokens(sgndSuppTokens, false);
        Collection<PolicyAssertion> endSuppTokens = this.findAndAssertPolicy(SP12Constants.ENDORSING_SUPPORTING_TOKENS);
        this.endSuppTokMap = this.handleSupportingTokens(endSuppTokens, true);
        Collection<PolicyAssertion> sgndEndSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS);
        this.sgndEndSuppTokMap = this.handleSupportingTokens(sgndEndSuppTokens, true);
        Collection<PolicyAssertion> sgndEncryptedSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS);
        Map<Token, WSSecBase> sgndEncSuppTokMap = this.handleSupportingTokens(sgndEncryptedSuppTokens, false);
        Collection<PolicyAssertion> endorsingEncryptedSuppTokens = this.findAndAssertPolicy(SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS);
        this.endEncSuppTokMap = this.handleSupportingTokens(endorsingEncryptedSuppTokens, true);
        Collection<PolicyAssertion> sgndEndEncSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS);
        this.sgndEndEncSuppTokMap = this.handleSupportingTokens(sgndEndEncSuppTokens, true);
        Collection<PolicyAssertion> supportingToks = this.findAndAssertPolicy(SP12Constants.SUPPORTING_TOKENS);
        this.handleSupportingTokens(supportingToks, false);
        Collection<PolicyAssertion> encryptedSupportingToks = this.findAndAssertPolicy(SP12Constants.ENCRYPTED_SUPPORTING_TOKENS);
        this.handleSupportingTokens(encryptedSupportingToks, false);
        this.addSignatureParts(sigSuppTokMap, sigs);
        this.addSignatureParts(sgndEncSuppTokMap, sigs);
        this.addSignatureParts(this.sgndEndSuppTokMap, sigs);
        this.addSignatureParts(this.sgndEndEncSuppTokMap, sigs);
    }

    protected void doEndorse() {
        boolean tokenProtect = false;
        boolean sigProtect = false;
        if (this.binding instanceof AsymmetricBinding) {
            tokenProtect = ((AsymmetricBinding)this.binding).isTokenProtection();
            sigProtect = ((AsymmetricBinding)this.binding).isSignatureProtection();
        } else if (this.binding instanceof SymmetricBinding) {
            tokenProtect = ((SymmetricBinding)this.binding).isTokenProtection();
            sigProtect = ((SymmetricBinding)this.binding).isSignatureProtection();
        }
        this.endSuppTokMap.putAll(this.endEncSuppTokMap);
        this.doEndorsedSignatures(this.endSuppTokMap, tokenProtect, sigProtect);
        this.sgndEndSuppTokMap.putAll(this.sgndEndEncSuppTokMap);
        this.doEndorsedSignatures(this.sgndEndSuppTokMap, tokenProtect, sigProtect);
    }

    protected void addSignatureConfirmation(Vector<WSEncryptionPart> sigParts) {
        Wss10 wss10 = this.getWss10();
        if (!(wss10 instanceof Wss11) || !((Wss11)wss10).isRequireSignatureConfirmation()) {
            return;
        }
        Vector results = (Vector)this.message.getExchange().getInMessage().get((Object)"RECV_RESULTS");
        Vector signatureActions = new Vector();
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult wshResult = (WSHandlerResult)results.get(i);
            WSSecurityUtil.fetchAllActionResults((Vector)wshResult.getResults(), (int)2, signatureActions);
            WSSecurityUtil.fetchAllActionResults((Vector)wshResult.getResults(), (int)16, signatureActions);
            WSSecurityUtil.fetchAllActionResults((Vector)wshResult.getResults(), (int)64, signatureActions);
        }
        WSSecSignatureConfirmation wsc = new WSSecSignatureConfirmation();
        if (signatureActions.size() > 0) {
            for (int i = 0; i < signatureActions.size(); ++i) {
                WSSecurityEngineResult wsr = (WSSecurityEngineResult)signatureActions.get(i);
                byte[] sigVal = (byte[])wsr.get((Object)"signature-value");
                wsc.setSignatureValue(sigVal);
                wsc.prepare((Document)this.saaj.getSOAPPart());
                this.addSupportingElement(wsc.getSignatureConfirmationElement());
                if (sigParts == null) continue;
                sigParts.add(new WSEncryptionPart(wsc.getId()));
            }
        } else {
            wsc.prepare((Document)this.saaj.getSOAPPart());
            this.addSupportingElement(wsc.getSignatureConfirmationElement());
            if (sigParts != null) {
                sigParts.add(new WSEncryptionPart(wsc.getId()));
            }
        }
    }

    public void handleEncryptedSignedHeaders(Vector<WSEncryptionPart> encryptedParts, Vector<WSEncryptionPart> signedParts) {
        Vector<WSEncryptionPart> signedEncryptedParts = new Vector<WSEncryptionPart>();
        for (WSEncryptionPart encryptedPart : encryptedParts) {
            Iterator<WSEncryptionPart> signedPartsIt = signedParts.iterator();
            while (signedPartsIt.hasNext()) {
                WSEncryptionPart signedPart = signedPartsIt.next();
                if (signedPart.getId() == null && !"Token".equals(signedPart.getName())) {
                    throw new IllegalArgumentException("WSEncryptionPart must be ID based but no id was found.");
                }
                if (!encryptedPart.getEncModifier().equals("Element") || !signedPart.getId().equals(encryptedPart.getId())) continue;
                signedPartsIt.remove();
                signedEncryptedParts.add(new WSEncryptionPart(encryptedPart.getEncId(), encryptedPart.getEncModifier(), encryptedPart.getType()));
            }
        }
        signedParts.addAll(signedEncryptedParts);
    }

    private static final class WSSecSignatureHelper
    extends WSSecSignature {
        private WSSecSignatureHelper() {
        }

        public SecurityTokenReference getSecRef() {
            return this.secRef;
        }

        public String getStrUri() {
            return this.strUri;
        }

        public void addReferencesToSign(Vector references, WSSecHeader secHeader) throws WSSecurityException {
            Vector<WSEncryptionPart> unalteredReferences = new Vector<WSEncryptionPart>();
            try {
                for (int part = 0; part < references.size(); ++part) {
                    WSEncryptionPart encPart = (WSEncryptionPart)references.get(part);
                    String elemName = encPart.getName();
                    Transforms transforms = new Transforms(this.document);
                    if (elemName != null && "ExternalSTRTransform".equals(encPart.getNamespace())) {
                        Element ctx = this.createSTRParameter(this.document);
                        transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                        this.sig.addDocument("#" + elemName, transforms, this.getDigestAlgo());
                        continue;
                    }
                    unalteredReferences.add(encPart);
                }
            }
            catch (TransformationException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, (Throwable)e1);
            }
            catch (XMLSignatureException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, (Throwable)e1);
            }
            super.addReferencesToSign(unalteredReferences, secHeader);
        }
    }
}

