/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import javax.security.auth.Subject;
import org.apache.cxf.security.SecurityContext;

public class DefaultSecurityContext
implements SecurityContext {
    private Principal p;
    private Subject subject;

    public DefaultSecurityContext(Principal p, Subject subject) {
        this.p = p;
        this.subject = subject;
    }

    public Principal getUserPrincipal() {
        return this.p;
    }

    public boolean isUserInRole(String role) {
        if (this.subject == null || this.subject.getPrincipals().size() <= 1) {
            return false;
        }
        for (Principal principal : this.subject.getPrincipals()) {
            if (!(principal instanceof Group) || !this.checkGroup((Group)principal, role)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkGroup(Group group, String role) {
        if (group.getName().equals(role)) {
            return true;
        }
        Enumeration members = group.members();
        while (members.hasMoreElements()) {
            Principal member = (Principal)members.nextElement();
            if (!member.getName().equals(role) && (!(member instanceof Group) || !this.checkGroup((Group)member, role))) continue;
            return true;
        }
        return false;
    }
}

