/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyEngine;

public class ServerPolicyOutFaultInterceptor
extends AbstractPolicyInterceptor {
    public static final ServerPolicyOutFaultInterceptor INSTANCE = new ServerPolicyOutFaultInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(ServerPolicyOutFaultInterceptor.class);

    public ServerPolicyOutFaultInterceptor() {
        super("org.apache.cxf.ws.policy.ServerPolicyOutFaultInterceptor", "setup");
    }

    protected void handle(Message msg) {
        if (MessageUtils.isRequestor((Message)msg)) {
            LOG.fine("Is a requestor.");
            return;
        }
        Exchange exchange = msg.getExchange();
        assert (null != exchange);
        BindingOperationInfo boi = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        if (null == boi) {
            LOG.fine("No binding operation info.");
            return;
        }
        Endpoint e = (Endpoint)exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        Bus bus = (Bus)exchange.get(Bus.class);
        PolicyEngine pe = (PolicyEngine)bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        Destination destination = exchange.getDestination();
        Exception ex = (Exception)exchange.get(Exception.class);
        assert (null != ex);
        BindingFaultInfo bfi = this.getBindingFaultInfo(msg, ex, boi);
        if (bfi == null && msg.get(FaultMode.class) != FaultMode.UNCHECKED_APPLICATION_FAULT && msg.get(FaultMode.class) != FaultMode.CHECKED_APPLICATION_FAULT) {
            return;
        }
        EffectivePolicy effectivePolicy = pe.getEffectiveServerFaultPolicy(ei, boi, bfi, destination);
        if (effectivePolicy == null) {
            return;
        }
        List interceptors = effectivePolicy.getInterceptors();
        for (Interceptor oi : interceptors) {
            msg.getInterceptorChain().add(oi);
            LOG.log(Level.FINE, "Added interceptor of type {0}", oi.getClass().getSimpleName());
        }
        Collection assertions = effectivePolicy.getChosenAlternative();
        if (null != assertions && !assertions.isEmpty()) {
            msg.put(AssertionInfoMap.class, (Object)new AssertionInfoMap(assertions));
        }
    }
}

