/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSListenerPool;
import org.apache.cxf.transport.jms.JMSListenerPoolableObjectFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSOutputStream;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class JMSConduit
extends AbstractConduit
implements JMSExchangeSender,
MessageListener {
    static final Logger LOG = LogUtils.getL7dLogger(JMSConduit.class);
    private static final String CORRELATED = JMSConduit.class.getName() + ".correlated";
    private EndpointInfo endpointInfo;
    private JMSConfiguration jmsConfig;
    private Map<String, Exchange> correlationMap;
    private DefaultMessageListenerContainer jmsListener;
    private DefaultMessageListenerContainer allListener;
    private String conduitId;
    private AtomicLong messageCount;
    private JMSBusLifeCycleListener listener;
    private Bus bus;
    private JMSListenerPool listenerPool;
    private final Map<String, AbstractMessageListenerContainer> listenerMap;

    public JMSConduit(EndpointInfo endpointInfo, EndpointReferenceType target, JMSConfiguration jmsConfig, Bus b) {
        super(target);
        this.bus = b;
        this.jmsConfig = jmsConfig;
        this.endpointInfo = endpointInfo;
        this.correlationMap = new ConcurrentHashMap<String, Exchange>();
        this.conduitId = UUID.randomUUID().toString().replaceAll("-", "");
        this.messageCount = new AtomicLong(0L);
        this.listenerPool = new JMSListenerPool(new JMSListenerPoolableObjectFactory(jmsConfig, this));
        this.listenerMap = new ConcurrentHashMap<String, AbstractMessageListenerContainer>();
    }

    public void prepare(org.apache.cxf.message.Message message) throws IOException {
        String name = this.endpointInfo.getName().toString() + ".jms-conduit";
        org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INSUFFICIENT_CONFIGURATION_CONDUIT", LOG, new Object[]{name});
        this.jmsConfig.ensureProperlyConfigured(msg);
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        JMSOutputStream out = new JMSOutputStream(this, message.getExchange(), isTextPayload);
        message.setContent(OutputStream.class, (Object)out);
    }

    private synchronized AbstractMessageListenerContainer getJMSListener() {
        if (this.jmsListener == null) {
            this.jmsListener = JMSFactory.createJmsListener(this.jmsConfig, this, this.jmsConfig.getReplyDestination(), this.conduitId, false);
            this.addBusListener();
        }
        return this.jmsListener;
    }

    private synchronized AbstractMessageListenerContainer getAllListener() {
        if (this.allListener == null) {
            this.allListener = JMSFactory.createJmsListener(this.jmsConfig, this, this.jmsConfig.getReplyDestination(), null, true);
            this.addBusListener();
        }
        return this.allListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendExchange(Exchange exchange, final Object request) {
        String correlationId;
        LOG.log(Level.FINE, "JMSConduit send message");
        final org.apache.cxf.message.Message outMessage = exchange.getOutMessage();
        if (outMessage == null) {
            throw new RuntimeException("Exchange to be sent has no outMessage");
        }
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        if (isTextPayload && MessageUtils.isTrue((Object)outMessage.getContextualProperty("mtom-enabled")) && outMessage.getAttachments() != null && outMessage.getAttachments().size() > 0) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INVALID_MESSAGE_TYPE", LOG, new Object[0]);
            throw new ConfigurationException(msg);
        }
        JMSMessageHeadersType headers = (JMSMessageHeadersType)outMessage.get((Object)"org.apache.cxf.jms.client.request.headers");
        final JmsTemplate jmsTemplate = JMSFactory.createJmsTemplate(this.jmsConfig, headers);
        String userCID = headers != null ? headers.getJMSCorrelationID() : null;
        DefaultMessageListenerContainer jmsList = this.jmsListener;
        Destination replyTo = null;
        if (!exchange.isOneWay()) {
            if (this.jmsConfig.isUseMessageIDAsCorrelationID()) {
                if (!exchange.isSynchronous()) {
                    try {
                        jmsList = (AbstractMessageListenerContainer)this.listenerPool.borrowObject();
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "Failed to obtain listener from pool: " + ex);
                        throw new RuntimeException("Failed to obtain listener from pool.", ex);
                    }
                    replyTo = jmsList.getDestination();
                } else {
                    String replyToName = this.jmsConfig.getReplyDestination();
                    replyTo = JMSFactory.resolveOrCreateDestination(jmsTemplate, replyToName, this.jmsConfig.isPubSubDomain());
                }
            } else if (userCID == null || !this.jmsConfig.isUseConduitIdSelector()) {
                jmsList = this.getJMSListener();
                replyTo = jmsList.getDestination();
            } else {
                jmsList = this.getAllListener();
                replyTo = jmsList.getDestination();
            }
        }
        String string = correlationId = headers != null && headers.isSetJMSCorrelationID() ? headers.getJMSCorrelationID() : JMSUtils.createCorrelationId(this.jmsConfig.getConduitSelectorPrefix() + this.conduitId, this.messageCount.incrementAndGet());
        if (this.jmsConfig.isUseMessageIDAsCorrelationID()) {
            correlationId = null;
        }
        if (exchange.isOneWay() && !this.jmsConfig.isEnforceSpec() && JMSConduit.isSetReplyTo(outMessage)) {
            String replyToName;
            String string2 = replyToName = headers != null ? headers.getJMSReplyTo() : null;
            if (replyToName == null && this.jmsConfig.getReplyDestination() != null) {
                replyToName = this.jmsConfig.getReplyDestination();
            }
            if (replyToName != null) {
                replyTo = JMSFactory.resolveOrCreateDestination(jmsTemplate, replyToName, this.jmsConfig.isPubSubDomain());
            }
        }
        final Destination replyToDestination = replyTo;
        final String cid = correlationId;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class JMSConduitMessageCreator
        implements MessageCreator {
            Message jmsMessage;

            JMSConduitMessageCreator() {
            }

            public Message createMessage(Session session) throws JMSException {
                String messageType = JMSConduit.this.jmsConfig.getMessageType();
                Destination destination = replyToDestination;
                String replyToAddress = JMSConduit.this.jmsConfig.getReplyToDestination();
                if (replyToAddress != null) {
                    destination = JMSFactory.resolveOrCreateDestination(jmsTemplate, replyToAddress, JMSConduit.this.jmsConfig.isPubSubDomain());
                }
                this.jmsMessage = JMSUtils.buildJMSMessageFromCXFMessage(outMessage, request, messageType, session, destination, cid);
                LOG.log(Level.FINE, "client sending request: ", this.jmsMessage);
                return this.jmsMessage;
            }
        }
        JMSConduitMessageCreator messageCreator = new JMSConduitMessageCreator();
        if (!exchange.isOneWay()) {
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                if (correlationId != null) {
                    this.correlationMap.put(correlationId, exchange);
                }
                jmsTemplate.send(this.jmsConfig.getTargetDestination(), (MessageCreator)messageCreator);
                if (this.jmsConfig.isUseMessageIDAsCorrelationID()) {
                    try {
                        correlationId = messageCreator.jmsMessage.getJMSMessageID();
                        this.handleMessageIDAsCorrelationID(correlationId, exchange, jmsTemplate, replyTo, (AbstractMessageListenerContainer)jmsList);
                    }
                    catch (JMSException jmsex) {
                        throw JmsUtils.convertJmsAccessException((JMSException)jmsex);
                    }
                }
                if (exchange.isSynchronous()) {
                    try {
                        exchange.wait(jmsTemplate.getReceiveTimeout());
                    }
                    catch (InterruptedException e) {
                        this.correlationMap.remove(correlationId);
                        throw new RuntimeException(e);
                    }
                    this.correlationMap.remove(correlationId);
                    if (exchange.get((Object)CORRELATED) == null) {
                        throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
                    }
                }
            }
        }
        jmsTemplate.send(this.jmsConfig.getTargetDestination(), (MessageCreator)messageCreator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleMessageIDAsCorrelationID(String correlationId, Exchange exchange, JmsTemplate jmsTemplate, Destination replyTo, AbstractMessageListenerContainer poolListener) {
        String messageSelector = "JMSCorrelationID='" + correlationId + "'";
        if (exchange.isSynchronous()) {
            Message message = jmsTemplate.receiveSelected(replyTo, messageSelector);
            if (message == null) throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
            this.handleMessage(exchange, message);
            return;
        } else {
            this.correlationMap.put(correlationId, exchange);
            poolListener.setMessageSelector("JMSCorrelationID='" + correlationId + "'");
            if (!poolListener.isActive()) {
                poolListener.initialize();
            }
            this.listenerMap.put(correlationId, poolListener);
        }
    }

    private synchronized void addBusListener() {
        BusLifeCycleManager blcm;
        if (this.listener == null && this.bus != null && (blcm = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)) != null) {
            this.listener = new JMSBusLifeCycleListener(this, blcm);
        }
    }

    public void onMessage(Message jmsMessage) {
        Exchange exchange;
        String correlationId;
        try {
            correlationId = jmsMessage.getJMSCorrelationID();
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
        AbstractMessageListenerContainer poolListener = this.listenerMap.remove(correlationId);
        if (poolListener != null) {
            try {
                this.listenerPool.returnObject(poolListener);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Could not return listener to pool: " + ex);
            }
        }
        if ((exchange = this.correlationMap.remove(correlationId)) == null) {
            LOG.log(Level.WARNING, "Could not correlate message with correlationId " + correlationId);
            return;
        }
        this.handleMessage(exchange, jmsMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Exchange exchange, Message jmsMessage) {
        MessageImpl inMessage = new MessageImpl();
        exchange.setInMessage((org.apache.cxf.message.Message)inMessage);
        LOG.log(Level.FINE, "client received reply: ", jmsMessage);
        try {
            JMSUtils.populateIncomingContext(jmsMessage, (org.apache.cxf.message.Message)inMessage, "org.apache.cxf.jms.client.response.headers");
            byte[] response = JMSUtils.retrievePayload(jmsMessage, (String)inMessage.get((Object)org.apache.cxf.message.Message.ENCODING));
            LOG.log(Level.FINE, "The Response Message payload is : [" + response + "]");
            inMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream(response));
            if (exchange.isSynchronous()) {
                Exchange exchange2 = exchange;
                synchronized (exchange2) {
                    exchange.put((Object)CORRELATED, (Object)Boolean.TRUE);
                    exchange.notifyAll();
                }
            }
            if (this.incomingObserver != null) {
                this.incomingObserver.onMessage(exchange.getInMessage());
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().log(Level.WARNING, "can't get the right encoding information " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.listenerPool != null) {
            try {
                this.listenerPool.close();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Failed to close JMSListener pool: " + ex);
            }
            finally {
                this.listenerPool = null;
            }
        }
        if (this.listener != null) {
            this.listener.unreg();
            this.listener = null;
        }
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
        }
        if (this.allListener != null) {
            this.allListener.shutdown();
        }
        this.jmsConfig.destroyWrappedConnectionFactory();
        LOG.log(Level.FINE, "JMSConduit closed ");
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected static boolean isSetReplyTo(org.apache.cxf.message.Message message) {
        Boolean ret = (Boolean)message.get((Object)"org.apache.cxf.jms.client.set.replyto");
        return ret == null || ret != null && ret != false;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static class JMSBusLifeCycleListener
    implements BusLifeCycleListener {
        final WeakReference<JMSConduit> ref;
        BusLifeCycleManager blcm;

        JMSBusLifeCycleListener(JMSConduit c, BusLifeCycleManager b) {
            this.ref = new WeakReference<JMSConduit>(c);
            this.blcm = b;
            this.blcm.registerLifeCycleListener((BusLifeCycleListener)this);
        }

        public void initComplete() {
        }

        public void postShutdown() {
        }

        public void preShutdown() {
            this.unreg();
            this.blcm = null;
            JMSConduit c = (JMSConduit)this.ref.get();
            if (c != null) {
                c.listener = null;
                c.close();
            }
        }

        public void unreg() {
            if (this.blcm != null) {
                this.blcm.unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }
}

