/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.servlet;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.ssl.SslHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cxf.transport.http.netty.server.servlet.ChannelThreadLocal;
import org.apache.cxf.transport.http.netty.server.servlet.NettyServletInputStream;
import org.apache.cxf.transport.http.netty.server.servlet.URIParser;
import org.apache.cxf.transport.http.netty.server.util.Utils;

public class NettyHttpServletRequest
implements HttpServletRequest {
    private static final String SSL_CIPHER_SUITE_ATTRIBUTE = "javax.servlet.request.cipher_suite";
    private static final String SSL_PEER_CERT_CHAIN_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private URIParser uriParser;
    private HttpRequest originalRequest;
    private NettyServletInputStream inputStream;
    private BufferedReader reader;
    private QueryStringDecoder queryStringDecoder;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private String characterEncoding;
    private String contextPath;
    private ChannelHandlerContext channelHandlerContext;

    public NettyHttpServletRequest(HttpRequest request, String contextPath, ChannelHandlerContext ctx) {
        SSLSession session;
        this.originalRequest = request;
        this.contextPath = contextPath;
        this.uriParser = new URIParser(contextPath);
        this.uriParser.parse(request.uri());
        this.inputStream = new NettyServletInputStream((HttpContent)request);
        this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.inputStream)));
        this.queryStringDecoder = new QueryStringDecoder(request.uri());
        this.channelHandlerContext = ctx;
        SslHandler sslHandler = (SslHandler)this.channelHandlerContext.pipeline().get(SslHandler.class);
        if (sslHandler != null && (session = sslHandler.engine().getSession()) != null) {
            this.attributes.put(SSL_CIPHER_SUITE_ATTRIBUTE, session.getCipherSuite());
            try {
                this.attributes.put(SSL_PEER_CERT_CHAIN_ATTRIBUTE, session.getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
    }

    public HttpRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public javax.servlet.http.Cookie[] getCookies() {
        Set cookies;
        String cookieString = this.originalRequest.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (cookieString != null && !(cookies = ServerCookieDecoder.STRICT.decode(cookieString)).isEmpty()) {
            javax.servlet.http.Cookie[] cookiesArray = new javax.servlet.http.Cookie[cookies.size()];
            int indx = 0;
            for (Cookie c : cookies) {
                javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(c.name(), c.value());
                cookie.setDomain(c.domain());
                cookie.setMaxAge((int)c.maxAge());
                cookie.setPath(c.path());
                cookie.setSecure(c.isSecure());
                cookiesArray[indx] = cookie;
                ++indx;
            }
            return cookiesArray;
        }
        return null;
    }

    public long getDateHeader(String name) {
        String longVal = this.getHeader(name);
        if (longVal == null) {
            return -1L;
        }
        return Long.parseLong(longVal);
    }

    public String getHeader(String name) {
        return this.originalRequest.headers().get(name);
    }

    public Enumeration getHeaderNames() {
        return Utils.enumeration(this.originalRequest.headers().names());
    }

    public Enumeration getHeaders(String name) {
        return Utils.enumeration(this.originalRequest.headers().getAll(name));
    }

    public int getIntHeader(String name) {
        return this.originalRequest.headers().getInt((CharSequence)name, -1);
    }

    public String getMethod() {
        return this.originalRequest.method().name();
    }

    public String getQueryString() {
        return this.uriParser.getQueryString();
    }

    public String getRequestURI() {
        return this.uriParser.getRequestUri();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        String urlPath = this.getRequestURI();
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if ("http".equalsIgnoreCase(scheme) && port != 80 || "https".equalsIgnoreCase(scheme) && port != 443) {
            url.append(':');
            url.append(this.getServerPort());
        }
        url.append(urlPath);
        return url;
    }

    public int getContentLength() {
        return HttpUtil.getContentLength((HttpMessage)this.originalRequest, (int)-1);
    }

    public String getContentType() {
        return this.originalRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = Utils.getCharsetFromContentType(this.getContentType());
        }
        return this.characterEncoding;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return values != null ? values[0] : null;
    }

    public Map getParameterMap() {
        return this.queryStringDecoder.parameters();
    }

    public Enumeration getParameterNames() {
        return Utils.enumerationFromKeys(this.queryStringDecoder.parameters());
    }

    public String[] getParameterValues(String name) {
        List values = (List)this.queryStringDecoder.parameters().get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public String getProtocol() {
        return this.originalRequest.protocolVersion().toString();
    }

    public Object getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        return Utils.enumerationFromKeys(this.attributes);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public BufferedReader getReader() throws IOException {
        return this.reader;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        return null;
    }

    public String getPathInfo() {
        return this.uriParser.getPathInfo();
    }

    public Locale getLocale() {
        String locale = this.originalRequest.headers().get((CharSequence)HttpHeaderNames.ACCEPT_LANGUAGE, DEFAULT_LOCALE.toString());
        return new Locale(locale);
    }

    public String getRemoteAddr() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().remoteAddress();
        return addr.getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().remoteAddress();
        return addr.getHostName();
    }

    public int getRemotePort() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().remoteAddress();
        return addr.getPort();
    }

    public String getServerName() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().localAddress();
        return addr.getHostName();
    }

    public int getServerPort() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().localAddress();
        return addr.getPort();
    }

    public String getServletPath() {
        String servletPath = this.uriParser.getServletPath();
        if ("/".equals(servletPath)) {
            return "";
        }
        return servletPath;
    }

    public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public boolean isSecure() {
        return ChannelThreadLocal.get().pipeline().get(SslHandler.class) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public String getLocalAddr() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().localAddress();
        return addr.getAddress().getHostAddress();
    }

    public String getLocalName() {
        return this.getServerName();
    }

    public int getLocalPort() {
        return this.getServerPort();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.characterEncoding = env;
    }

    public Enumeration getLocales() {
        Collection<Locale> locales = Utils.parseAcceptLanguageHeader(this.originalRequest.headers().get((CharSequence)HttpHeaderNames.ACCEPT_LANGUAGE));
        if (locales == null || locales.isEmpty()) {
            locales = new ArrayList<Locale>();
            locales.add(Locale.getDefault());
        }
        return Utils.enumeration(locales);
    }

    public String getAuthType() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new IllegalStateException("Method 'isRequestedSessionIdFromURL' not yet implemented!");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new IllegalStateException("Method 'isRequestedSessionIdFromUrl' not yet implemented!");
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String role) {
        throw new IllegalStateException("Method 'isUserInRole' not yet implemented!");
    }

    public String getRealPath(String path) {
        throw new IllegalStateException("Method 'getRealPath' not yet implemented!");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new IllegalStateException("Method 'getRequestDispatcher' not yet implemented!");
    }
}

