/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpResponse;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientRequest;

public class NettyHttpClientHandler
extends ChannelDuplexHandler {
    private final BlockingQueue<NettyHttpClientRequest> sendedQueue = new LinkedBlockingDeque<NettyHttpClientRequest>();

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            NettyHttpClientRequest request = (NettyHttpClientRequest)this.sendedQueue.poll();
            request.setResponse(response);
            request.getCxfResponseCallback().responseReceived(response);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof NettyHttpClientRequest) {
            NettyHttpClientRequest request = (NettyHttpClientRequest)msg;
            this.sendedQueue.put(request);
            ctx.writeAndFlush((Object)request.getRequest());
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

