/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.resource.ResourceManager;

public final class SecurityUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SecurityUtils.class);

    private SecurityUtils() {
    }

    public static CallbackHandler getCallbackHandler(Object o) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), SecurityUtils.class).newInstance();
        }
        return handler;
    }

    public static URL getConfigFileURL(Message message, String configFileKey, String configFileDefault) {
        Object o = message.getContextualProperty(configFileKey);
        if (o == null) {
            o = configFileDefault;
        }
        return SecurityUtils.loadResource(message, o);
    }

    public static URL loadResource(Object o) {
        return SecurityUtils.loadResource((Message)null, o);
    }

    public static URL loadResource(Message message, Object o) {
        Message msg = message;
        if (msg == null) {
            msg = PhaseInterceptorChain.getCurrentMessage();
        }
        ResourceManager manager = null;
        if (msg != null && msg.getExchange() != null && msg.getExchange().get(Bus.class) != null) {
            manager = (ResourceManager)((Bus)msg.getExchange().get(Bus.class)).getExtension(ResourceManager.class);
        }
        return SecurityUtils.loadResource(manager, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL loadResource(ResourceManager manager, Object o) {
        if (o instanceof String) {
            URL url = ClassLoaderUtils.getResource((String)((String)o), SecurityUtils.class);
            if (url != null) {
                return url;
            }
            ClassLoaderUtils.ClassLoaderHolder orig = null;
            try {
                if (manager != null) {
                    ClassLoader loader = (ClassLoader)manager.resolveResource((String)o, ClassLoader.class);
                    if (loader != null) {
                        orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                    }
                    url = (URL)manager.resolveResource((String)o, URL.class);
                }
                if (url == null) {
                    try {
                        url = new URL((String)o);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (url == null) {
                    try {
                        URI propResourceUri = URI.create((String)o);
                        if (propResourceUri.getScheme() != null) {
                            url = propResourceUri.toURL();
                        } else {
                            File f = new File(propResourceUri.toString());
                            if (f.exists()) {
                                url = f.toURI().toURL();
                            }
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                URL uRL = url;
                return uRL;
            }
            finally {
                if (orig != null) {
                    orig.reset();
                }
            }
        }
        if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    public static Properties loadProperties(Object o) {
        if (o instanceof Properties) {
            return (Properties)o;
        }
        URL url = null;
        if (o instanceof String) {
            url = SecurityUtils.loadResource(o);
        } else if (o instanceof URL) {
            url = (URL)o;
        }
        if (url != null) {
            Properties properties = new Properties();
            try {
                InputStream ins = url.openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
            return properties;
        }
        return null;
    }

    public static Object getSecurityPropertyValue(String property, Message message) {
        Object value = message.getContextualProperty(property);
        if (value != null) {
            return value;
        }
        return message.getContextualProperty("ws-" + property);
    }
}

