/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.openapi;

import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.jaxrs2.ResolvedParameter;
import io.swagger.v3.jaxrs2.ext.AbstractOpenAPIExtension;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtension;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.MatrixParam;

public class JaxRs2Extension
extends AbstractOpenAPIExtension {
    public ResolvedParameter extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Components components, Consumes classConsumes, Consumes methodConsumes, boolean includeRequestBody, Iterator<OpenAPIExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ResolvedParameter();
        }
        List parameters = annotations.stream().filter(annotation -> annotation instanceof MatrixParam).map(annotation -> {
            MatrixParam param = (MatrixParam)annotation;
            Parameter mp = new PathParameter().name(param.value());
            mp.setStyle(Parameter.StyleEnum.MATRIX);
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(type);
            if (resolvedSchema != null) {
                mp.setSchema(resolvedSchema.schema);
            }
            this.applyBeanValidatorAnnotations(mp, annotations);
            return mp;
        }).collect(Collectors.toList());
        if (parameters.isEmpty()) {
            return super.extractParameters(annotations, type, typesToSkip, components, classConsumes, methodConsumes, includeRequestBody, chain);
        }
        ResolvedParameter resolved = new ResolvedParameter();
        resolved.parameters = parameters;
        return resolved;
    }

    private void applyBeanValidatorAnnotations(Parameter parameter, List<Annotation> annotations) {
        Max max;
        Min min;
        HashMap annos = new HashMap();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getName(), annotation));
        }
        if (annos.containsKey(NotNull.class.getName())) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        if (annos.containsKey(Min.class.getName())) {
            min = (Min)annos.get(Min.class.getName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getName())) {
            max = (Max)annos.get(Max.class.getName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        if (annos.containsKey(Size.class.getName())) {
            Size size = (Size)annos.get(Size.class.getName());
            schema.setMinimum(BigDecimal.valueOf(size.min()));
            schema.setMaximum(BigDecimal.valueOf(size.max()));
            schema.setMinItems(Integer.valueOf(size.min()));
            schema.setMaxItems(Integer.valueOf(size.max()));
        }
        if (annos.containsKey(DecimalMin.class.getName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(new Double(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey(DecimalMax.class.getName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(new Double(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey(Pattern.class.getName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getName());
            schema.setPattern(pattern.regexp());
        }
    }
}

