/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.microprofile.openapi;

import jakarta.ws.rs.core.Application;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.common.openapi.DefaultApplicationFactory;
import org.apache.cxf.jaxrs.common.openapi.SwaggerProperties;
import org.apache.cxf.jaxrs.microprofile.openapi.OpenApiEndpoint;
import org.apache.cxf.jaxrs.microprofile.openapi.SwaggerUi;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiConfig;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiSupport;
import org.apache.geronimo.microprofile.openapi.config.GeronimoOpenAPIConfig;
import org.apache.geronimo.microprofile.openapi.impl.model.ContactImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.InfoImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.LicenseImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.OpenAPIImpl;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotationProcessor;
import org.apache.geronimo.microprofile.openapi.impl.processor.reflect.ClassElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.reflect.MethodElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.spi.NamingStrategy;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;

@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Server)
public class OpenApiFeature
extends DelegatingFeature<Portable>
implements SwaggerUiSupport,
SwaggerProperties {
    public OpenApiFeature() {
        super((AbstractPortableFeature)new Portable());
    }

    public boolean isScan() {
        return ((Portable)this.delegate).isScan();
    }

    public void setScan(boolean scan) {
        ((Portable)this.delegate).setScan(scan);
    }

    public String getFilterClass() {
        return ((Portable)this.delegate).getFilterClass();
    }

    public void setFilterClass(String filterClass) {
        ((Portable)this.delegate).setFilterClass(filterClass);
    }

    public Set<String> getResourcePackages() {
        return ((Portable)this.delegate).getResourcePackages();
    }

    public void setResourcePackages(Set<String> resourcePackages) {
        ((Portable)this.delegate).setResourcePackages(resourcePackages);
    }

    public String getVersion() {
        return ((Portable)this.delegate).getVersion();
    }

    public void setVersion(String version) {
        ((Portable)this.delegate).setVersion(version);
    }

    public String getTitle() {
        return ((Portable)this.delegate).getTitle();
    }

    public void setTitle(String title) {
        ((Portable)this.delegate).setTitle(title);
    }

    public String getDescription() {
        return ((Portable)this.delegate).getDescription();
    }

    public void setDescription(String description) {
        ((Portable)this.delegate).setDescription(description);
    }

    public String getContactName() {
        return ((Portable)this.delegate).getContactName();
    }

    public void setContactName(String contactName) {
        ((Portable)this.delegate).setContactName(contactName);
    }

    public String getContactEmail() {
        return ((Portable)this.delegate).getContactEmail();
    }

    public void setContactEmail(String contactEmail) {
        ((Portable)this.delegate).setContactEmail(contactEmail);
    }

    public String getContactUrl() {
        return ((Portable)this.delegate).getContactUrl();
    }

    public void setContactUrl(String contactUrl) {
        ((Portable)this.delegate).setContactUrl(contactUrl);
    }

    public String getLicense() {
        return ((Portable)this.delegate).getLicense();
    }

    public void setLicense(String license) {
        ((Portable)this.delegate).setLicense(license);
    }

    public String getLicenseUrl() {
        return ((Portable)this.delegate).getLicenseUrl();
    }

    public void setLicenseUrl(String licenseUrl) {
        ((Portable)this.delegate).setLicenseUrl(licenseUrl);
    }

    public String getTermsOfServiceUrl() {
        return ((Portable)this.delegate).getTermsOfServiceUrl();
    }

    public void setTermsOfServiceUrl(String termsOfServiceUrl) {
        ((Portable)this.delegate).setTermsOfServiceUrl(termsOfServiceUrl);
    }

    public boolean isReadAllResources() {
        return ((Portable)this.delegate).isReadAllResources();
    }

    public void setReadAllResources(boolean readAllResources) {
        ((Portable)this.delegate).setReadAllResources(readAllResources);
    }

    public Set<String> getResourceClasses() {
        return ((Portable)this.delegate).getResourceClasses();
    }

    public void setResourceClasses(Set<String> resourceClasses) {
        ((Portable)this.delegate).setResourceClasses(resourceClasses);
    }

    public Collection<String> getIgnoredRoutes() {
        return ((Portable)this.delegate).getIgnoredRoutes();
    }

    public void setIgnoredRoutes(Collection<String> ignoredRoutes) {
        ((Portable)this.delegate).setIgnoredRoutes(ignoredRoutes);
    }

    public boolean isPrettyPrint() {
        return ((Portable)this.delegate).isPrettyPrint();
    }

    public void setPrettyPrint(boolean prettyPrint) {
        ((Portable)this.delegate).setPrettyPrint(prettyPrint);
    }

    public boolean isRunAsFilter() {
        return ((Portable)this.delegate).isRunAsFilter();
    }

    public Boolean isSupportSwaggerUi() {
        return ((Portable)this.delegate).isSupportSwaggerUi();
    }

    public void setSupportSwaggerUi(Boolean supportSwaggerUi) {
        ((Portable)this.delegate).setSupportSwaggerUi(supportSwaggerUi);
    }

    public String getSwaggerUiVersion() {
        return ((Portable)this.delegate).getSwaggerUiVersion();
    }

    public void setSwaggerUiVersion(String swaggerUiVersion) {
        ((Portable)this.delegate).setSwaggerUiVersion(swaggerUiVersion);
    }

    public String getSwaggerUiMavenGroupAndArtifact() {
        return ((Portable)this.delegate).getSwaggerUiMavenGroupAndArtifact();
    }

    public void setSwaggerUiMavenGroupAndArtifact(String swaggerUiMavenGroupAndArtifact) {
        ((Portable)this.delegate).setSwaggerUiMavenGroupAndArtifact(swaggerUiMavenGroupAndArtifact);
    }

    public Map<String, String> getSwaggerUiMediaTypes() {
        return ((Portable)this.delegate).getSwaggerUiMediaTypes();
    }

    public void setSwaggerUiMediaTypes(Map<String, String> swaggerUiMediaTypes) {
        ((Portable)this.delegate).setSwaggerUiMediaTypes(swaggerUiMediaTypes);
    }

    public String getConfigLocation() {
        return ((Portable)this.delegate).getConfigLocation();
    }

    public void setConfigLocation(String configLocation) {
        ((Portable)this.delegate).setConfigLocation(configLocation);
    }

    public String getPropertiesLocation() {
        return ((Portable)this.delegate).getPropertiesLocation();
    }

    public void setPropertiesLocation(String propertiesLocation) {
        ((Portable)this.delegate).setPropertiesLocation(propertiesLocation);
    }

    public void setRunAsFilter(boolean runAsFilter) {
        ((Portable)this.delegate).setRunAsFilter(runAsFilter);
    }

    public void setScanKnownConfigLocations(boolean scanKnownConfigLocations) {
        ((Portable)this.delegate).setScanKnownConfigLocations(scanKnownConfigLocations);
    }

    public boolean isScanKnownConfigLocations() {
        return ((Portable)this.delegate).isScanKnownConfigLocations();
    }

    public void setSwaggerUiConfig(SwaggerUiConfig swaggerUiConfig) {
        ((Portable)this.delegate).setSwaggerUiConfig(swaggerUiConfig);
    }

    public SwaggerUiConfig getSwaggerUiConfig() {
        return ((Portable)this.delegate).getSwaggerUiConfig();
    }

    public String findSwaggerUiRoot() {
        return ((Portable)this.delegate).findSwaggerUiRoot();
    }

    protected Properties getUserProperties(Map<String, Object> userDefinedOptions) {
        return ((Portable)this.delegate).getUserProperties(userDefinedOptions);
    }

    protected void registerOpenApiResources(JAXRSServiceFactoryBean sfb, OpenAPI openApiDefinition) {
        ((Portable)this.delegate).registerOpenApiResources(sfb, openApiDefinition);
    }

    protected void registerSwaggerUiResources(JAXRSServiceFactoryBean sfb, Properties properties, ServerProviderFactory factory, Bus bus) {
        ((Portable)this.delegate).registerSwaggerUiResources(sfb, properties, factory, bus);
    }

    public static class Portable
    implements AbstractPortableFeature,
    SwaggerUiSupport,
    SwaggerProperties {
        private static final Logger LOG = LogUtils.getL7dLogger(OpenApiFeature.class);
        private String version;
        private String title;
        private String description;
        private String contactName;
        private String contactEmail;
        private String contactUrl;
        private String license;
        private String licenseUrl;
        private String termsOfServiceUrl;
        private boolean readAllResources = true;
        private boolean scan = true;
        private boolean prettyPrint = true;
        private boolean runAsFilter;
        private Collection<String> ignoredRoutes;
        private Set<String> resourcePackages;
        private Set<String> resourceClasses;
        private String filterClass;
        private Boolean supportSwaggerUi;
        private String swaggerUiVersion;
        private String swaggerUiMavenGroupAndArtifact;
        private Map<String, String> swaggerUiMediaTypes;
        private String configLocation;
        private String propertiesLocation = "/swagger.properties";
        private boolean scanKnownConfigLocations = true;
        private SwaggerUiConfig swaggerUiConfig;

        public void initialize(Server server, Bus bus) {
            JAXRSServiceFactoryBean sfb = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
            ServerProviderFactory factory = (ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName());
            HashSet<String> packages = new HashSet<String>();
            if (this.resourcePackages != null) {
                packages.addAll(this.resourcePackages);
            }
            Application application = DefaultApplicationFactory.createApplicationOrDefault((Server)server, (ServerProviderFactory)factory, (JAXRSServiceFactoryBean)sfb, (Bus)bus, this.resourcePackages, (boolean)this.isScan());
            AnnotationProcessor processor = new AnnotationProcessor(GeronimoOpenAPIConfig.create(), (NamingStrategy)new NamingStrategy.Http(), null);
            OpenAPIImpl api = new OpenAPIImpl();
            if (this.isScan()) {
                packages.addAll(this.scanResourcePackages(sfb));
            }
            HashSet resources = new HashSet();
            if (application != null) {
                processor.processApplication((OpenAPI)api, (AnnotatedElement)new ClassElement(application.getClass()));
                LOG.fine("Processed application " + application);
                if (application.getClasses() != null) {
                    resources.addAll(application.getClasses());
                }
            }
            resources.addAll(sfb.getClassResourceInfo().stream().map(AbstractResourceInfo::getServiceClass).filter(cls -> Portable.filterByPackage(cls, packages)).filter(cls -> Portable.filterByClassName(cls, this.resourceClasses)).collect(Collectors.toSet()));
            if (!resources.isEmpty()) {
                String binding = application == null ? "" : processor.getApplicationBinding(application.getClass());
                resources.stream().peek(c -> LOG.info("Processing class " + c.getName())).forEach(c -> processor.processClass(binding, (OpenAPI)api, (AnnotatedElement)new ClassElement(c), Stream.of(c.getMethods()).map(MethodElement::new)));
            } else {
                LOG.warning("No resource classes registered, the OpenAPI will not contain any endpoints.");
            }
            Properties swaggerProps = this.getSwaggerProperties(this.propertiesLocation, bus);
            if (api.getInfo() == null) {
                api.setInfo(this.getInfo(swaggerProps));
            }
            this.registerOpenApiResources(sfb, (OpenAPI)api);
            this.registerSwaggerUiResources(sfb, swaggerProps, factory, bus);
        }

        public boolean isScan() {
            return this.scan;
        }

        public void setScan(boolean scan) {
            this.scan = scan;
        }

        public String getFilterClass() {
            return this.filterClass;
        }

        public void setFilterClass(String filterClass) {
            this.filterClass = filterClass;
        }

        public Set<String> getResourcePackages() {
            return this.resourcePackages;
        }

        public void setResourcePackages(Set<String> resourcePackages) {
            this.resourcePackages = resourcePackages == null ? null : new HashSet<String>(resourcePackages);
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getContactName() {
            return this.contactName;
        }

        public void setContactName(String contactName) {
            this.contactName = contactName;
        }

        public String getContactEmail() {
            return this.contactEmail;
        }

        public void setContactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
        }

        public String getContactUrl() {
            return this.contactUrl;
        }

        public void setContactUrl(String contactUrl) {
            this.contactUrl = contactUrl;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLicense(String license) {
            this.license = license;
        }

        public String getLicenseUrl() {
            return this.licenseUrl;
        }

        public void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public String getTermsOfServiceUrl() {
            return this.termsOfServiceUrl;
        }

        public void setTermsOfServiceUrl(String termsOfServiceUrl) {
            this.termsOfServiceUrl = termsOfServiceUrl;
        }

        public boolean isReadAllResources() {
            return this.readAllResources;
        }

        public void setReadAllResources(boolean readAllResources) {
            this.readAllResources = readAllResources;
        }

        public Set<String> getResourceClasses() {
            return this.resourceClasses;
        }

        public void setResourceClasses(Set<String> resourceClasses) {
            this.resourceClasses = resourceClasses == null ? null : new HashSet<String>(resourceClasses);
        }

        public Collection<String> getIgnoredRoutes() {
            return this.ignoredRoutes;
        }

        public void setIgnoredRoutes(Collection<String> ignoredRoutes) {
            this.ignoredRoutes = ignoredRoutes == null ? null : new HashSet<String>(ignoredRoutes);
        }

        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        public void setPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
        }

        public boolean isRunAsFilter() {
            return this.runAsFilter;
        }

        public Boolean isSupportSwaggerUi() {
            return this.supportSwaggerUi;
        }

        public void setSupportSwaggerUi(Boolean supportSwaggerUi) {
            this.supportSwaggerUi = supportSwaggerUi;
        }

        public String getSwaggerUiVersion() {
            return this.swaggerUiVersion;
        }

        public void setSwaggerUiVersion(String swaggerUiVersion) {
            this.swaggerUiVersion = swaggerUiVersion;
        }

        public String getSwaggerUiMavenGroupAndArtifact() {
            return this.swaggerUiMavenGroupAndArtifact;
        }

        public void setSwaggerUiMavenGroupAndArtifact(String swaggerUiMavenGroupAndArtifact) {
            this.swaggerUiMavenGroupAndArtifact = swaggerUiMavenGroupAndArtifact;
        }

        public Map<String, String> getSwaggerUiMediaTypes() {
            return this.swaggerUiMediaTypes;
        }

        public void setSwaggerUiMediaTypes(Map<String, String> swaggerUiMediaTypes) {
            this.swaggerUiMediaTypes = swaggerUiMediaTypes;
        }

        public String getConfigLocation() {
            return this.configLocation;
        }

        public void setConfigLocation(String configLocation) {
            this.configLocation = configLocation;
        }

        public String getPropertiesLocation() {
            return this.propertiesLocation;
        }

        public void setPropertiesLocation(String propertiesLocation) {
            this.propertiesLocation = propertiesLocation;
        }

        public void setRunAsFilter(boolean runAsFilter) {
            this.runAsFilter = runAsFilter;
        }

        public void setScanKnownConfigLocations(boolean scanKnownConfigLocations) {
            this.scanKnownConfigLocations = scanKnownConfigLocations;
        }

        public boolean isScanKnownConfigLocations() {
            return this.scanKnownConfigLocations;
        }

        public void setSwaggerUiConfig(SwaggerUiConfig swaggerUiConfig) {
            this.swaggerUiConfig = swaggerUiConfig;
        }

        public SwaggerUiConfig getSwaggerUiConfig() {
            return this.swaggerUiConfig;
        }

        public String findSwaggerUiRoot() {
            return SwaggerUi.findSwaggerUiRoot(this.swaggerUiMavenGroupAndArtifact, this.swaggerUiVersion);
        }

        protected Properties getUserProperties(Map<String, Object> userDefinedOptions) {
            Properties properties = new Properties();
            if (userDefinedOptions != null) {
                userDefinedOptions.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> properties.setProperty((String)entry.getKey(), entry.getValue().toString()));
            }
            return properties;
        }

        protected void registerOpenApiResources(JAXRSServiceFactoryBean sfb, OpenAPI openApiDefinition) {
            sfb.setResourceClassesFromBeans(Collections.singletonList(new OpenApiEndpoint(openApiDefinition)));
        }

        protected void registerSwaggerUiResources(JAXRSServiceFactoryBean sfb, Properties properties, ServerProviderFactory factory, Bus bus) {
            SwaggerUiSupport.Registration swaggerUiRegistration = this.getSwaggerUi(bus, properties, this.isRunAsFilter());
            if (!this.isRunAsFilter()) {
                sfb.setResourceClassesFromBeans(swaggerUiRegistration.getResources());
            }
            factory.setUserProviders(swaggerUiRegistration.getProviders());
        }

        private Info getInfo(Properties properties) {
            Info info = new InfoImpl().title(this.getOrFallback(this.getTitle(), properties, "title")).version(this.getOrFallback(this.getVersion(), properties, "version")).description(this.getOrFallback(this.getDescription(), properties, "description")).termsOfService(this.getOrFallback(this.getTermsOfServiceUrl(), properties, "terms.url")).contact(new ContactImpl().name(this.getOrFallback(this.getContactName(), properties, "contact")).email(this.getContactEmail()).url(this.getContactUrl()));
            String licenseName = this.getOrFallback(this.getLicense(), properties, "license");
            if (licenseName != null) {
                info = info.license(new LicenseImpl().name(this.getOrFallback(this.getLicense(), properties, "license")).url(this.getOrFallback(this.getLicenseUrl(), properties, "license.url")));
            }
            return info;
        }

        private String getOrFallback(String value, Properties properties, String property) {
            if (value == null && properties != null) {
                return properties.getProperty(property);
            }
            return value;
        }

        private Collection<String> scanResourcePackages(JAXRSServiceFactoryBean sfb) {
            return sfb.getClassResourceInfo().stream().map(cri -> cri.getServiceClass().getPackage().getName()).collect(Collectors.toSet());
        }

        private static boolean filterByPackage(Class<?> cls, Set<String> packages) {
            return packages == null || packages.isEmpty() || packages.stream().anyMatch(pkg -> cls.getPackage().getName().startsWith((String)pkg));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean filterByClassName(Class<?> cls, Set<String> classes) {
            if (classes == null) return true;
            if (classes.isEmpty()) return true;
            if (!classes.stream().anyMatch(cls.getName()::equalsIgnoreCase)) return false;
            return true;
        }
    }
}

