/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.RSSecurityUtils;
import org.apache.cxf.rs.security.saml.assertion.Subject;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.opensaml.saml.saml2.core.NameID;
import org.w3c.dom.Element;

public final class SAMLUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLUtils.class);

    private SAMLUtils() {
    }

    public static Subject getSubject(Message message, SamlAssertionWrapper assertionW) {
        org.opensaml.saml.saml2.core.Subject s = assertionW.getSaml2().getSubject();
        Subject subject = new Subject();
        NameID nameId = s.getNameID();
        subject.setNameQualifier(nameId.getNameQualifier());
        subject.setNameFormat(nameId.getFormat());
        subject.setName(nameId.getValue());
        subject.setSpId(nameId.getSPProvidedID());
        subject.setSpQualifier(nameId.getSPNameQualifier());
        return subject;
    }

    public static SamlAssertionWrapper createAssertion(Message message) throws Fault {
        try {
            Element samlToken = (Element)MessageUtils.getContextualProperty((Message)message, (String)"ws-security.token.element", (String)"rs-security.saml.token.element");
            if (samlToken != null) {
                return new SamlAssertionWrapper(samlToken);
            }
            CallbackHandler handler = RSSecurityUtils.getCallbackHandler(message, SAMLUtils.class, "security.saml-callback-handler");
            return SAMLUtils.createAssertion(message, handler);
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            LOG.warning(sw.toString());
            throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }

    public static SamlAssertionWrapper createAssertion(Message message, CallbackHandler handler) throws Fault {
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)handler, (SAMLCallback)samlCallback);
        try {
            SamlAssertionWrapper assertion = new SamlAssertionWrapper(samlCallback);
            if (samlCallback.isSignAssertion()) {
                Crypto crypto = new CryptoLoader().getCrypto(message, "security.signature.crypto", "security.signature.properties");
                String user = RSSecurityUtils.getUserName(message, crypto, "security.signature.username");
                if (StringUtils.isEmpty((String)user)) {
                    return assertion;
                }
                String password = RSSecurityUtils.getPassword(message, user, 3, SAMLUtils.class);
                assertion.signAssertion(user, password, crypto, false, samlCallback.getCanonicalizationAlgorithm(), samlCallback.getSignatureAlgorithm(), samlCallback.getSignatureDigestAlgorithm());
            }
            return assertion;
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            LOG.warning(sw.toString());
            throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }

    public static SamlAssertionWrapper createAssertion(CallbackHandler handler, SelfSignInfo info) throws Fault {
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)handler, (SAMLCallback)samlCallback);
        try {
            SamlAssertionWrapper assertion = new SamlAssertionWrapper(samlCallback);
            assertion.signAssertion(info.getUser(), info.getPassword(), info.getCrypto(), false);
            return assertion;
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            LOG.warning(sw.toString());
            throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }

    public static class SelfSignInfo {
        private Crypto crypto;
        private String user;
        private String password;

        public SelfSignInfo(Crypto crypto, String user, String password) {
            this.crypto = crypto;
            this.user = user;
            this.password = password;
        }

        public Crypto getCrypto() {
            return this.crypto;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

