/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;

public class CryptoLoader {
    private static final String CRYPTO_CACHE = "rs-security-xml-crypto.cache";

    public Crypto loadCrypto(String cryptoResource) throws IOException, WSSecurityException {
        URL url = ClassLoaderUtils.getResource((String)cryptoResource, this.getClass());
        if (url != null) {
            return CryptoLoader.loadCryptoFromURL(url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Crypto getCrypto(Message message, String cryptoKey, String propKey) throws IOException, WSSecurityException {
        Crypto crypto = (Crypto)message.getContextualProperty(cryptoKey);
        if (crypto != null) {
            return crypto;
        }
        Object o = message.getContextualProperty(propKey);
        if (o == null) {
            return null;
        }
        Map<Object, Crypto> cryptoCache = this.getCryptoCache(message);
        Crypto crypto2 = crypto = cryptoCache != null ? cryptoCache.get(o) : null;
        if (crypto != null) {
            return crypto;
        }
        ClassLoaderUtils.ClassLoaderHolder orig = null;
        try {
            URL url = ClassLoaderUtils.getResource((String)((String)o), this.getClass());
            if (url == null) {
                ResourceManager manager = (ResourceManager)message.getExchange().getBus().getExtension(ResourceManager.class);
                ClassLoader loader = (ClassLoader)manager.resolveResource("", ClassLoader.class);
                if (loader != null) {
                    orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                }
                url = (URL)manager.resolveResource((String)o, URL.class);
            }
            crypto = url != null ? CryptoLoader.loadCryptoFromURL(url) : CryptoFactory.getInstance((String)((String)o));
            if (cryptoCache != null) {
                cryptoCache.put(o, crypto);
            }
            Crypto crypto3 = crypto;
            return crypto3;
        }
        finally {
            if (orig != null) {
                orig.reset();
            }
        }
    }

    public static Crypto loadCryptoFromURL(URL url) throws IOException, WSSecurityException {
        Properties props = new Properties();
        InputStream in = url.openStream();
        props.load(in);
        in.close();
        return CryptoFactory.getInstance((Properties)props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Object, Crypto> getCryptoCache(Message message) {
        Endpoint endpoint = (Endpoint)message.getExchange().get(Endpoint.class);
        if (endpoint != null) {
            EndpointInfo info;
            EndpointInfo endpointInfo = info = endpoint.getEndpointInfo();
            synchronized (endpointInfo) {
                ConcurrentHashMap<Object, Crypto> o = CastUtils.cast((Map)((Map)info.getProperty(CRYPTO_CACHE)));
                if (o == null) {
                    o = new ConcurrentHashMap<Object, Crypto>();
                    info.setProperty(CRYPTO_CACHE, o);
                }
                return o;
            }
        }
        return null;
    }
}

