/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.zip.DataFormatException;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.opensaml.xml.XMLObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="sso")
public class RequestAssertionConsumerService {
    private static final String SAML_RESPONSE = "SAMLResponse";
    private static final String RELAY_STATE = "RelayState";
    private boolean useDeflateEncoding = true;

    @POST
    @Produces(value={"application/x-www-form-urlencoded"})
    public Response processSamlResponse(@Encoded @FormParam(value="RelayState") String relayState, @Encoded @FormParam(value="SAMLResponse") String encodedSamlResponse) {
        org.opensaml.saml2.core.Response samlResponse = this.readSAMLResponse(encodedSamlResponse);
        this.validateSamlResponse(samlResponse);
        String responseTo = samlResponse.getInResponseTo();
        UriBuilder builder = UriBuilder.fromPath((String)responseTo);
        return Response.seeOther((URI)builder.build(new Object[0])).build();
    }

    @GET
    public Response getSamlResponse(@Encoded @QueryParam(value="RelayState") String relayState, @Encoded @QueryParam(value="SAMLResponse") String samlResponse) {
        return this.processSamlResponse(relayState, samlResponse);
    }

    private org.opensaml.saml2.core.Response readSAMLResponse(String samlResponse) {
        if (StringUtils.isEmpty((String)samlResponse)) {
            throw new WebApplicationException(400);
        }
        InputStream tokenStream = null;
        try {
            byte[] deflatedToken = Base64Utility.decode((String)samlResponse);
            tokenStream = this.useDeflateEncoding() ? new DeflateEncoderDecoder().inflateToken(deflatedToken) : new ByteArrayInputStream(deflatedToken);
        }
        catch (Base64Exception ex) {
            throw new WebApplicationException(400);
        }
        catch (DataFormatException ex) {
            throw new WebApplicationException(400);
        }
        Document responseDoc = null;
        try {
            responseDoc = DOMUtils.readXml((Reader)new InputStreamReader(tokenStream, "UTF-8"));
        }
        catch (Exception ex) {
            throw new WebApplicationException(400);
        }
        XMLObject responseObject = null;
        try {
            responseObject = OpenSAMLUtil.fromDom((Element)responseDoc.getDocumentElement());
        }
        catch (WSSecurityException ex) {
            throw new WebApplicationException(400);
        }
        if (!(responseObject instanceof org.opensaml.saml2.core.Response)) {
            throw new WebApplicationException(400);
        }
        return (org.opensaml.saml2.core.Response)responseObject;
    }

    protected void validateSamlResponse(org.opensaml.saml2.core.Response samlResponse) {
    }

    public void setUseDeflateEncoding(boolean deflate) {
        this.useDeflateEncoding = deflate;
    }

    public boolean useDeflateEncoding() {
        return this.useDeflateEncoding;
    }
}

