/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.client.ClientCodeRequestFilter;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oidc.common.ClaimsRequest;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.IdTokenReader;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContextImpl;
import org.apache.cxf.rs.security.oidc.rp.OidcSecurityContext;
import org.apache.cxf.rs.security.oidc.rp.UserInfoClient;

public class OidcClientCodeRequestFilter
extends ClientCodeRequestFilter {
    private static final String ACR_PARAMETER = "acr_values";
    private static final String LOGIN_HINT_PARAMETER = "login_hint";
    private static final String MAX_AGE_PARAMETER = "max_age";
    private static final String PROMPT_PARAMETER = "prompt";
    private static final List<String> PROMPTS = Arrays.asList("none", "consent", "login", "select_account");
    private IdTokenReader idTokenReader;
    private UserInfoClient userInfoClient;
    private List<String> authenticationContextRef;
    private String promptLogin;
    private Long maxAgeOffset;
    private String claims;
    private String claimsLocales;
    private String roleClaim;

    public OidcClientCodeRequestFilter() {
        this.setScopes("openid");
    }

    public void setAuthenticationContextRef(String acr) {
        this.authenticationContextRef = Arrays.asList(StringUtils.split((String)acr, (String)" "));
    }

    protected ClientTokenContext createTokenContext(ContainerRequestContext rc, ClientAccessToken at, MultivaluedMap<String, String> requestParams, MultivaluedMap<String, String> state) {
        if (rc.getSecurityContext() instanceof OidcSecurityContext) {
            return ((OidcSecurityContext)rc.getSecurityContext()).getOidcContext();
        }
        OidcClientTokenContextImpl ctx = new OidcClientTokenContextImpl();
        if (at != null) {
            if (this.idTokenReader == null) {
                throw new OAuthServiceException("server_error");
            }
            IdToken idToken = this.idTokenReader.getIdToken(at, (String)requestParams.getFirst((Object)"code"), this.getConsumer());
            this.validateIdToken(idToken, state);
            ctx.setIdToken(idToken);
            if (this.userInfoClient != null) {
                ctx.setUserInfo(this.userInfoClient.getUserInfo(at, ctx.getIdToken(), this.getConsumer()));
            }
            OidcSecurityContext oidcSecCtx = new OidcSecurityContext(ctx);
            oidcSecCtx.setRoleClaim(this.roleClaim);
            rc.setSecurityContext((SecurityContext)oidcSecCtx);
        }
        return ctx;
    }

    protected MultivaluedMap<String, String> toCodeRequestState(ContainerRequestContext rc, UriInfo ui) {
        MultivaluedMap state = super.toCodeRequestState(rc, ui);
        if (this.maxAgeOffset != null) {
            state.putSingle((Object)MAX_AGE_PARAMETER, (Object)Long.toString(System.currentTimeMillis() + this.maxAgeOffset));
        }
        return state;
    }

    private void validateIdToken(IdToken idToken, MultivaluedMap<String, String> state) {
        String acr;
        String nonce = (String)state.getFirst((Object)"nonce");
        String tokenNonce = idToken.getNonce();
        if (!(nonce == null || tokenNonce != null && nonce.equals(tokenNonce))) {
            throw new OAuthServiceException("invalid_request");
        }
        if (this.maxAgeOffset != null) {
            Long authTime = Long.parseLong((String)state.getFirst((Object)MAX_AGE_PARAMETER));
            Long tokenAuthTime = idToken.getAuthenticationTime();
            if (tokenAuthTime > authTime) {
                throw new OAuthServiceException("invalid_request");
            }
        }
        if ((acr = idToken.getAuthenticationContextRef()) != null && this.authenticationContextRef != null && !this.authenticationContextRef.contains(acr)) {
            throw new OAuthServiceException("invalid_request");
        }
    }

    public void setIdTokenReader(IdTokenReader idTokenReader) {
        this.idTokenReader = idTokenReader;
    }

    public void setUserInfoClient(UserInfoClient userInfoClient) {
        this.userInfoClient = userInfoClient;
    }

    protected void checkSecurityContextStart(ContainerRequestContext rc) {
        SecurityContext sc = rc.getSecurityContext();
        if (!(sc instanceof OidcSecurityContext) && sc.getUserPrincipal() != null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    protected void setAdditionalCodeRequestParams(UriBuilder ub, MultivaluedMap<String, String> redirectState, MultivaluedMap<String, String> codeRequestState) {
        if (redirectState != null) {
            if (redirectState.getFirst((Object)"nonce") != null) {
                ub.queryParam("nonce", new Object[]{redirectState.getFirst((Object)"nonce")});
            }
            if (redirectState.getFirst((Object)MAX_AGE_PARAMETER) != null) {
                ub.queryParam(MAX_AGE_PARAMETER, new Object[]{redirectState.getFirst((Object)MAX_AGE_PARAMETER)});
            }
        }
        if (codeRequestState != null && codeRequestState.getFirst((Object)LOGIN_HINT_PARAMETER) != null) {
            ub.queryParam(LOGIN_HINT_PARAMETER, new Object[]{codeRequestState.getFirst((Object)LOGIN_HINT_PARAMETER)});
        }
        if (this.claims != null) {
            ub.queryParam("claims", new Object[]{this.claims});
        }
        if (this.claimsLocales != null) {
            ub.queryParam("claims_locales", new Object[]{this.claimsLocales});
        }
        if (this.authenticationContextRef != null) {
            ub.queryParam(ACR_PARAMETER, new Object[]{this.authenticationContextRef});
        }
        if (this.promptLogin != null) {
            ub.queryParam(PROMPT_PARAMETER, new Object[]{this.promptLogin});
        }
    }

    public void setPromptLogin(String promptLogin) {
        if (!PROMPTS.contains(promptLogin)) {
            throw new IllegalArgumentException("Illegal prompt value");
        }
        this.promptLogin = promptLogin;
    }

    public void setMaxAgeOffset(Long maxAgeOffset) {
        this.maxAgeOffset = maxAgeOffset;
    }

    public void setClaimsRequest(ClaimsRequest claimsRequest) {
        this.setClaims(new JsonMapObjectReaderWriter().toJson((JsonMapObject)claimsRequest));
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public void setClaimsLocales(String claimsLocales) {
        this.claimsLocales = claimsLocales;
    }

    public void setRoleClaim(String roleClaim) {
        this.roleClaim = roleClaim;
    }
}

