/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenResponseFilter;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class AbstractImplicitGrantService
extends RedirectionBasedGrantService {
    private boolean reportClientId;
    private List<AccessTokenResponseFilter> responseHandlers = new LinkedList<AccessTokenResponseFilter>();

    protected AbstractImplicitGrantService(String supportedResponseType, String supportedGrantType) {
        super(supportedResponseType, supportedGrantType);
    }

    @Override
    protected Response createGrant(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ServerAccessToken token = null;
        if (preAuthorizedToken == null) {
            AccessTokenRegistration reg = new AccessTokenRegistration();
            reg.setClient(client);
            reg.setGrantType(super.getSupportedGrantType());
            reg.setSubject(userSubject);
            reg.setRequestedScope(requestedScope);
            if (approvedScope != null && approvedScope.isEmpty()) {
                reg.setApprovedScope(requestedScope);
            } else {
                reg.setApprovedScope(approvedScope);
            }
            reg.setAudience(state.getAudience());
            token = this.getDataProvider().createAccessToken(reg);
        } else {
            token = preAuthorizedToken;
        }
        ClientAccessToken clientToken = OAuthUtils.toClientAccessToken(token, this.isWriteOptionalParameters());
        this.processClientAccessToken(clientToken, token);
        StringBuilder sb = this.getUriWithFragment(state.getRedirectUri());
        sb.append("access_token").append("=").append(clientToken.getTokenKey());
        if (state.getState() != null) {
            sb.append("&");
            sb.append("state").append("=").append(state.getState());
        }
        sb.append("&").append("token_type").append("=").append(clientToken.getTokenType());
        if (this.isWriteOptionalParameters()) {
            sb.append("&").append("expires_in").append("=").append(clientToken.getExpiresIn());
            if (!StringUtils.isEmpty((String)clientToken.getApprovedScope())) {
                sb.append("&").append("scope").append("=").append(HttpUtils.queryEncode((String)clientToken.getApprovedScope()));
            }
            for (Map.Entry<String, String> entry : clientToken.getParameters().entrySet()) {
                sb.append("&").append(entry.getKey()).append("=").append(HttpUtils.queryEncode((String)entry.getValue()));
            }
        }
        if (token.getRefreshToken() != null) {
            this.processRefreshToken(sb, token.getRefreshToken());
        }
        if (this.reportClientId) {
            sb.append("&").append("client_id").append("=").append(client.getClientId());
        }
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    protected void processRefreshToken(StringBuilder sb, String refreshToken) {
        LOG.warning("Implicit grant tokens MUST not have refresh tokens, refresh token will not be reported");
    }

    protected void processClientAccessToken(ClientAccessToken clientToken, ServerAccessToken serverToken) {
        for (AccessTokenResponseFilter filter : this.responseHandlers) {
            filter.process(clientToken, serverToken);
        }
    }

    @Override
    protected Response createErrorResponse(String state, String redirectUri, String error) {
        StringBuilder sb = this.getUriWithFragment(redirectUri);
        sb.append("error").append("=").append(error);
        if (state != null) {
            sb.append("&");
            sb.append("state").append("=").append(state);
        }
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    private StringBuilder getUriWithFragment(String redirectUri) {
        StringBuilder sb = new StringBuilder();
        sb.append(redirectUri);
        sb.append("#");
        return sb;
    }

    public void setReportClientId(boolean reportClientId) {
        this.reportClientId = reportClientId;
    }

    public void setResponseFilters(List<AccessTokenResponseFilter> handlers) {
        this.responseHandlers = handlers;
    }

    public void setResponseFilter(AccessTokenResponseFilter responseHandler) {
        this.responseHandlers.add(responseHandler);
    }

    @Override
    protected boolean canRedirectUriBeEmpty(Client c) {
        return false;
    }

    @Override
    protected boolean canSupportPublicClient(Client c) {
        return true;
    }
}

