/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.AbstractJoseJwtProducer;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public abstract class AbstractOAuthJoseJwtProducer
extends AbstractJoseJwtProducer {
    private boolean encryptWithClientSecret;
    private boolean signWithClientSecret;

    protected String processJwt(JwtToken jwt, String clientSecret) {
        return this.processJwt(jwt, this.getInitializedEncryptionProvider(clientSecret), this.getInitializedSignatureProvider(clientSecret));
    }

    protected JwsSignatureProvider getInitializedSignatureProvider(String clientSecret) {
        if (this.signWithClientSecret) {
            byte[] hmac = CryptoUtils.decodeSequence((String)clientSecret);
            return JwsUtils.getHmacSignatureProvider((byte[])hmac, (SignatureAlgorithm)SignatureAlgorithm.HS256);
        }
        return null;
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider(String clientSecret) {
        if (this.encryptWithClientSecret) {
            SecretKey key = CryptoUtils.decodeSecretKey((String)clientSecret);
            return JweUtils.getDirectKeyJweEncryption((SecretKey)key, (ContentAlgorithm)ContentAlgorithm.A128GCM);
        }
        return null;
    }

    public void setEncryptWithClientSecret(boolean encryptWithClientSecret) {
        if (this.signWithClientSecret) {
            throw new SecurityException();
        }
        this.encryptWithClientSecret = encryptWithClientSecret;
    }

    public void setSignWithClientSecret(boolean signWithClientSecret) {
        if (this.encryptWithClientSecret) {
            throw new SecurityException();
        }
        this.signWithClientSecret = signWithClientSecret;
    }

    public boolean isSignWithClientSecret() {
        return this.signWithClientSecret;
    }

    public boolean isEncryptWithClientSecret() {
        return this.encryptWithClientSecret;
    }
}

