/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.mac;

import java.security.SecureRandom;
import java.util.Map;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.oauth2.client.HttpRequestProperties;
import org.apache.cxf.rs.security.oauth2.common.AccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.mac.HmacUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacAuthorizationScheme {
    private static final String SEPARATOR = "\n";
    private HttpRequestProperties props;
    private String macKey;
    private String timestamp;
    private String nonce;

    public MacAuthorizationScheme(HttpRequestProperties props, AccessToken token) {
        this.props = props;
        this.macKey = token.getTokenKey();
        this.timestamp = Long.toString(System.currentTimeMillis());
        this.nonce = MacAuthorizationScheme.generateNonce();
    }

    public MacAuthorizationScheme(HttpRequestProperties props, Map<String, String> schemeParams) {
        this.props = props;
        this.macKey = schemeParams.get("id");
        this.timestamp = schemeParams.get("ts");
        this.nonce = schemeParams.get("nonce");
    }

    public String getMacKey() {
        return this.macKey;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String toAuthorizationHeader(String macAlgo, String macSecret) {
        String data = this.getNormalizedRequestString();
        String signature = HmacUtils.computeSignature(macAlgo, macSecret, data);
        StringBuilder sb = new StringBuilder();
        sb.append("MAC").append(" ");
        MacAuthorizationScheme.addParameter(sb, "id", this.macKey, false);
        MacAuthorizationScheme.addParameter(sb, "nonce", this.nonce, false);
        MacAuthorizationScheme.addParameter(sb, "mac", signature, false);
        MacAuthorizationScheme.addParameter(sb, "ts", this.timestamp, true);
        return sb.toString();
    }

    private static void addParameter(StringBuilder sb, String name, String value, boolean last) {
        sb.append(name).append('=').append('\"').append(value).append('\"');
        if (!last) {
            sb.append(',');
        }
    }

    public String getNormalizedRequestString() {
        String requestURI = this.props.getRequestPath();
        if (!StringUtils.isEmpty((String)this.props.getRequestQuery())) {
            requestURI = requestURI + "?" + MacAuthorizationScheme.normalizeQuery(this.props.getRequestQuery());
        }
        String value = this.timestamp + SEPARATOR + this.nonce + SEPARATOR + this.props.getHttpMethod().toUpperCase() + SEPARATOR + requestURI + SEPARATOR + this.props.getHostName() + SEPARATOR + this.props.getPort() + SEPARATOR + "" + SEPARATOR;
        return value;
    }

    private static String normalizeQuery(String query) {
        return query;
    }

    private static String generateNonce() {
        byte[] randomBytes = new byte[20];
        new SecureRandom().nextBytes(randomBytes);
        String random = Base64Utility.encode((byte[])randomBytes);
        return random;
    }
}

