/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Service;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.source.NodeDataReader;
import org.apache.cxf.databinding.source.XMLStreamDataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxws.handler.logical.DispatchLogicalHandlerInterceptor;
import org.apache.cxf.jaxws.handler.soap.DispatchSOAPHandlerInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DispatchInDatabindingInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchInDatabindingInterceptor.class);
    private Class type;
    private Service.Mode mode;

    public DispatchInDatabindingInterceptor(Class type, Service.Mode mode) {
        super("read");
        this.type = type;
        this.mode = mode;
    }

    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        if (this.isGET(message)) {
            MessageContentsList params = new MessageContentsList();
            params.add(null);
            message.setContent(List.class, (Object)params);
            LOG.info("DispatchInInterceptor skipped in HTTP GET method");
            return;
        }
        try {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            boolean msgRead = false;
            Object obj = null;
            ex.put(Service.Mode.class, (Object)this.mode);
            if (message instanceof SoapMessage) {
                SOAPMessage soapMessage = this.newSOAPMessage(is, (SoapMessage)message);
                soapMessage.countAttachments();
                soapMessage.getSOAPPart().getEnvelope();
                if (soapMessage.getSOAPBody().hasFault()) {
                    Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
                    message.getInterceptorChain().abort();
                    if (ep.getInFaultObserver() != null) {
                        message.setContent(SOAPMessage.class, (Object)soapMessage);
                        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Element)soapMessage.getSOAPBody().getFault());
                        reader.nextTag();
                        message.setContent(XMLStreamReader.class, (Object)reader);
                        ep.getInFaultObserver().onMessage(message);
                        return;
                    }
                }
                PostDispatchSOAPHandlerInterceptor postSoap = new PostDispatchSOAPHandlerInterceptor();
                message.getInterceptorChain().add((Interceptor)postSoap);
                message.setContent(SOAPMessage.class, (Object)soapMessage);
                msgRead = true;
            } else if (message instanceof XMLMessage) {
                if (this.type.equals(DataSource.class)) {
                    try {
                        obj = new ByteArrayDataSource(is, (String)message.get((Object)"Content-Type"));
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                    message.setContent(DataSource.class, obj);
                } else {
                    new AttachmentInInterceptor().handleMessage(message);
                    new StaxInInterceptor().handleMessage(message);
                    XMLStreamDataReader dataReader = new XMLStreamDataReader();
                    Class<Source> readType = this.type;
                    if (!Source.class.isAssignableFrom(this.type)) {
                        readType = Source.class;
                    }
                    obj = dataReader.read(null, message.getContent(XMLStreamReader.class), readType);
                    message.setContent(Source.class, obj);
                }
                msgRead = true;
            }
            if (msgRead) {
                PostDispatchLogicalHandlerInterceptor postLogical = new PostDispatchLogicalHandlerInterceptor();
                message.getInterceptorChain().add((Interceptor)postLogical);
                is.close();
                message.removeContent(InputStream.class);
            }
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private SOAPMessage newSOAPMessage(InputStream is, SoapMessage msg) throws Exception {
        SoapVersion version = msg.getVersion();
        MimeHeaders headers = new MimeHeaders();
        if (msg.containsKey((Object)Message.PROTOCOL_HEADERS)) {
            Map heads = CastUtils.cast((Map)((Map)msg.get((Object)Message.PROTOCOL_HEADERS)));
            for (Map.Entry entry : heads.entrySet()) {
                for (String val : (List)entry.getValue()) {
                    headers.addHeader((String)entry.getKey(), val);
                }
            }
        }
        MessageFactory msgFactory = null;
        if (version == null || version instanceof Soap11) {
            msgFactory = MessageFactory.newInstance();
        } else if (version instanceof Soap12) {
            msgFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        return msgFactory.createMessage(headers, is);
    }

    void setupBindingOperationInfo(Exchange exch, SOAPMessage msg) {
        if (exch.get(BindingOperationInfo.class) == null) {
            QName opName = null;
            try {
                SOAPBody body = msg.getSOAPBody();
                if (body != null) {
                    Node nd;
                    for (nd = body.getFirstChild(); nd != null && !(nd instanceof Element); nd = nd.getNextSibling()) {
                    }
                    if (nd != null) {
                        opName = new QName(nd.getNamespaceURI(), nd.getLocalName());
                    }
                }
                if (opName == null) {
                    return;
                }
            }
            catch (SOAPException e) {
                return;
            }
            BindingOperationInfo bop = ServiceModelUtil.getOperationForWrapperElement((Exchange)exch, opName, (boolean)false);
            if (bop == null) {
                bop = ServiceModelUtil.getOperation((Exchange)exch, opName);
            }
            if (bop != null) {
                exch.put(BindingOperationInfo.class, (Object)bop);
                exch.put(OperationInfo.class, (Object)bop.getOperationInfo());
                if (bop.getOutput() == null) {
                    exch.setOneWay(true);
                }
            }
        }
    }

    private Object convertSourceToJaxb(Source source, Message message) throws Exception {
        CachedOutputStream cos = new CachedOutputStream();
        Transformer transformer = XMLUtils.newTransformer();
        transformer.transform(source, new StreamResult((OutputStream)cos));
        String encoding = (String)message.get((Object)Message.ENCODING);
        XMLStreamReader reader = null;
        reader = StaxUtils.getXMLInputFactory().createXMLStreamReader(cos.getInputStream(), encoding);
        DataReader dataReader = this.getDataReader(message);
        dataReader.setProperty("unwrap.jaxb.element", (Object)Boolean.FALSE);
        Object obj = dataReader.read(null, (Object)reader, null);
        reader.close();
        cos.close();
        return obj;
    }

    static /* synthetic */ Service.Mode access$000(DispatchInDatabindingInterceptor x0) {
        return x0.mode;
    }

    private class PostDispatchLogicalHandlerInterceptor
    extends AbstractInDatabindingInterceptor {
        public PostDispatchLogicalHandlerInterceptor() {
            super("user-logical");
            this.addAfter(DispatchLogicalHandlerInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            Object obj = null;
            if (message instanceof SoapMessage) {
                Source source = (Source)message.getContent(Source.class);
                message.removeContent(Source.class);
                if (SOAPMessage.class.isAssignableFrom(DispatchInDatabindingInterceptor.this.type)) {
                    try {
                        SoapVersion version = ((SoapMessage)message).getVersion();
                        MessageFactory msgFactory = null;
                        if (version == null || version instanceof Soap11) {
                            msgFactory = MessageFactory.newInstance();
                        } else if (version instanceof Soap12) {
                            msgFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
                        }
                        SOAPMessage msg = msgFactory.createMessage();
                        msg.getSOAPPart().setContent(source);
                        if (message.getAttachments() != null) {
                            for (Attachment att : message.getAttachments()) {
                                AttachmentPart part = msg.createAttachmentPart(att.getDataHandler());
                                if (att.getId() != null) {
                                    part.setContentId(att.getId());
                                }
                                Iterator it = att.getHeaderNames();
                                while (it.hasNext()) {
                                    String s = (String)it.next();
                                    part.setMimeHeader(s, att.getHeader(s));
                                }
                                msg.addAttachmentPart(part);
                            }
                        }
                        obj = msg;
                        DispatchInDatabindingInterceptor.this.setupBindingOperationInfo(message.getExchange(), msg);
                    }
                    catch (Exception e) {
                        throw new Fault((Throwable)e);
                    }
                } else if (Source.class.isAssignableFrom(DispatchInDatabindingInterceptor.this.type)) {
                    obj = source;
                } else {
                    try {
                        obj = DispatchInDatabindingInterceptor.this.convertSourceToJaxb(source, message);
                    }
                    catch (Exception e) {
                        throw new Fault((Throwable)e);
                    }
                }
            } else if (message instanceof XMLMessage) {
                Source source = (Source)message.getContent(Source.class);
                message.removeContent(Source.class);
                DataSource dataSource = (DataSource)message.getContent(DataSource.class);
                message.removeContent(DataSource.class);
                if (source != null) {
                    if (Source.class.isAssignableFrom(DispatchInDatabindingInterceptor.this.type)) {
                        obj = source;
                    } else {
                        try {
                            obj = DispatchInDatabindingInterceptor.this.convertSourceToJaxb(source, message);
                        }
                        catch (Exception e) {
                            throw new Fault((Throwable)e);
                        }
                    }
                } else if (dataSource != null && DataSource.class.isAssignableFrom(DispatchInDatabindingInterceptor.this.type)) {
                    obj = dataSource;
                }
            }
            message.setContent(Object.class, obj);
        }
    }

    private class PostDispatchSOAPHandlerInterceptor
    extends AbstractInDatabindingInterceptor {
        public PostDispatchSOAPHandlerInterceptor() {
            super("user-protocol");
            this.addAfter(DispatchSOAPHandlerInterceptor.class.getName());
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void handleMessage(Message message) throws Fault {
            obj = null;
            if (message instanceof SoapMessage) {
                soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
                message.removeContent(SOAPMessage.class);
                DispatchInDatabindingInterceptor.this.setupBindingOperationInfo(message.getExchange(), soapMessage);
                dataReader = new NodeDataReader();
                n /* !! */  = null;
                if (DispatchInDatabindingInterceptor.access$000(DispatchInDatabindingInterceptor.this) == Service.Mode.MESSAGE) {
                    try {
                        n /* !! */  = soapMessage.getSOAPPart();
                        soapMessage.getSOAPPart().getEnvelope();
                        if (soapMessage.countAttachments() <= 0) ** GOTO lbl38
                        if (message.getAttachments() == null) {
                            message.setAttachments(new ArrayList<E>(soapMessage.countAttachments()));
                        }
                        it = CastUtils.cast((Iterator)soapMessage.getAttachments());
                        while (it.hasNext()) {
                            part = (AttachmentPart)it.next();
                            att = new AttachmentImpl(part.getContentId());
                            att.setDataHandler(part.getDataHandler());
                            it2 = CastUtils.cast((Iterator)part.getAllMimeHeaders());
                            while (it2.hasNext()) {
                                header = (MimeHeader)it2.next();
                                att.setHeader(header.getName(), header.getValue());
                            }
                            message.getAttachments().add(att);
                        }
                    }
                    catch (SOAPException e) {
                        throw new Fault((Throwable)e);
                    }
                } else if (DispatchInDatabindingInterceptor.access$000(DispatchInDatabindingInterceptor.this) == Service.Mode.PAYLOAD) {
                    try {
                        n /* !! */  = DOMUtils.getChild((Node)soapMessage.getSOAPBody(), (int)1);
                    }
                    catch (SOAPException e) {
                        throw new Fault((Throwable)e);
                    }
                }
lbl38:
                // 5 sources

                tempType = DispatchInDatabindingInterceptor.access$100(DispatchInDatabindingInterceptor.this);
                if (!Source.class.isAssignableFrom(DispatchInDatabindingInterceptor.access$100(DispatchInDatabindingInterceptor.this))) {
                    tempType = Source.class;
                }
                obj = dataReader.read(null, (Object)n /* !! */ , tempType);
                message.setContent(Source.class, obj);
            }
        }
    }
}

