/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.ClientMessageObserver;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.ClientOnlyHTTPTransportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractClient
implements Client {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractClient.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractClient.class);
    private static final String REQUEST_CONTEXT = "RequestContext";
    private static final String RESPONSE_CONTEXT = "ResponseContext";
    protected ClientConfiguration cfg = new ClientConfiguration();
    private ClientState state;

    protected AbstractClient(URI baseURI) {
        this.state = new LocalClientState(baseURI);
    }

    protected AbstractClient(ClientState initialState) {
        this.state = initialState;
    }

    @Override
    public Client header(String name, Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if ("Content-Type".equals(name)) {
            if (values.length > 1) {
                throw new IllegalArgumentException("Content-Type can have a single value only");
            }
            this.type(values[0].toString());
        } else {
            for (Object o : values) {
                this.possiblyAddHeader(name, o.toString());
            }
        }
        return this;
    }

    @Override
    public Client headers(MultivaluedMap<String, String> map) {
        this.state.getRequestHeaders().putAll(map);
        return this;
    }

    @Override
    public Client accept(MediaType ... types) {
        for (MediaType mt : types) {
            this.possiblyAddHeader("Accept", mt.toString());
        }
        return this;
    }

    @Override
    public Client type(MediaType ct) {
        return this.type(ct.toString());
    }

    @Override
    public Client type(String type) {
        this.state.getRequestHeaders().putSingle((Object)"Content-Type", (Object)type);
        return this;
    }

    @Override
    public Client accept(String ... types) {
        for (String type : types) {
            this.possiblyAddHeader("Accept", type);
        }
        return this;
    }

    @Override
    public Client cookie(Cookie cookie) {
        this.possiblyAddHeader("Cookie", cookie.toString());
        return this;
    }

    @Override
    public Client modified(Date date, boolean ifNot) {
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        String hName = ifNot ? "If-Unmodified-Since" : "If-Modified-Since";
        this.state.getRequestHeaders().putSingle((Object)hName, (Object)dateFormat.format(date));
        return this;
    }

    @Override
    public Client language(String language) {
        this.state.getRequestHeaders().putSingle((Object)"Content-Language", (Object)language);
        return this;
    }

    @Override
    public Client match(EntityTag tag, boolean ifNot) {
        String hName = ifNot ? "If-None-Match" : "If-Match";
        this.state.getRequestHeaders().putSingle((Object)hName, (Object)tag.toString());
        return this;
    }

    @Override
    public Client acceptLanguage(String ... languages) {
        for (String s : languages) {
            this.possiblyAddHeader("Accept-Language", s);
        }
        return this;
    }

    @Override
    public Client acceptEncoding(String ... encs) {
        for (String s : encs) {
            this.possiblyAddHeader("Accept-Encoding", s);
        }
        return this;
    }

    @Override
    public Client encoding(String enc) {
        this.state.getRequestHeaders().putSingle((Object)"Content-Encoding", (Object)enc);
        return this;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        MetadataMap<String, String> map = new MetadataMap<String, String>();
        map.putAll((Map)this.state.getRequestHeaders());
        return map;
    }

    @Override
    public URI getBaseURI() {
        return this.state.getBaseURI();
    }

    @Override
    public URI getCurrentURI() {
        return this.getCurrentBuilder().clone().buildFromEncoded(new Object[0]);
    }

    @Override
    public Response getResponse() {
        if (this.state.getResponseBuilder() == null) {
            return null;
        }
        return this.state.getResponseBuilder().clone().build();
    }

    @Override
    public Client reset() {
        this.state.reset();
        return this;
    }

    private void possiblyAddHeader(String name, String value) {
        if (!this.isDuplicate(name, value)) {
            this.state.getRequestHeaders().add((Object)name, (Object)value);
        }
    }

    private boolean isDuplicate(String name, String value) {
        List values = (List)this.state.getRequestHeaders().get((Object)name);
        return values != null && values.contains(value);
    }

    protected ClientState getState() {
        return this.state;
    }

    protected UriBuilder getCurrentBuilder() {
        return this.state.getCurrentBuilder();
    }

    protected void resetResponse() {
        this.state.setResponseBuilder(null);
    }

    protected void resetBaseAddress(URI uri) {
        this.state.setBaseURI(uri);
        this.resetCurrentBuilder(uri);
    }

    protected void resetCurrentBuilder(URI uri) {
        this.state.setCurrentBuilder(new UriBuilderImpl(uri));
    }

    protected MultivaluedMap<String, String> getTemplateParametersMap(URITemplate template, List<Object> values) {
        if (values != null && values.size() != 0) {
            List<String> vars = template.getVariables();
            MetadataMap<String, String> templatesMap = new MetadataMap<String, String>(vars.size());
            for (int i = 0; i < vars.size(); ++i) {
                if (i >= values.size()) continue;
                templatesMap.add(vars.get(i), values.get(i).toString());
            }
            return templatesMap;
        }
        return null;
    }

    protected Response.ResponseBuilder setResponseBuilder(HttpURLConnection conn, Exchange exchange) throws Throwable {
        Message inMessage = exchange.getInMessage();
        if (conn == null) {
            throw new ClientWebApplicationException("HTTP Connection is null");
        }
        Integer responseCode = (Integer)exchange.get((Object)Message.RESPONSE_CODE);
        if (responseCode == null) {
            Exception ex = (Exception)exchange.getOutMessage().getContent(Exception.class);
            if (ex != null) {
                throw ex;
            }
            throw new RuntimeException("Unknown client side exception");
        }
        int status = responseCode;
        Response.ResponseBuilder currentResponseBuilder = Response.status((int)status);
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            if (null == entry.getKey() || entry.getValue().size() <= 0) continue;
            if (HttpUtils.isDateRelatedHeader(entry.getKey())) {
                currentResponseBuilder.header(entry.getKey(), (Object)entry.getValue().get(0));
                continue;
            }
            for (String val : entry.getValue()) {
                String[] values;
                String[] stringArray;
                boolean splitPossible;
                boolean bl = splitPossible = !"Set-Cookie".equalsIgnoreCase(entry.getKey()) || !val.toUpperCase().contains("Expires".toUpperCase());
                if (splitPossible) {
                    stringArray = val.split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = val;
                }
                for (String s : values = stringArray) {
                    String theValue = s.trim();
                    if (theValue.length() <= 0) continue;
                    currentResponseBuilder.header(entry.getKey(), (Object)theValue);
                }
            }
        }
        InputStream mStream = null;
        if (inMessage != null) {
            mStream = (InputStream)inMessage.getContent(InputStream.class);
        }
        if (status >= 400) {
            try {
                InputStream errorStream = mStream == null ? conn.getErrorStream() : mStream;
                currentResponseBuilder.entity((Object)errorStream);
            }
            catch (Exception ex) {}
        } else {
            try {
                InputStream stream = mStream == null ? conn.getInputStream() : mStream;
                currentResponseBuilder.entity((Object)stream);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Response.ResponseBuilder rb = currentResponseBuilder.clone();
        this.state.setResponseBuilder(currentResponseBuilder);
        return rb;
    }

    protected void writeBody(Object o, Message outMessage, Class<?> cls, Type type, Annotation[] anns, MultivaluedMap<String, String> headers, OutputStream os) {
        if (o == null) {
            return;
        }
        MediaType contentType = MediaType.valueOf((String)((String)headers.getFirst((Object)"Content-Type")));
        MessageBodyWriter<?> mbw = ProviderFactory.getInstance(outMessage).createMessageBodyWriter(cls, type, anns, contentType, outMessage);
        if (mbw != null) {
            try {
                mbw.writeTo(o, cls, type, anns, contentType, headers, os);
                if (os != null) {
                    os.flush();
                }
            }
            catch (Exception ex) {
                AbstractClient.reportMessageHandlerProblem("MSG_WRITER_PROBLEM", cls, contentType, ex, null);
            }
        } else {
            AbstractClient.reportMessageHandlerProblem("NO_MSG_WRITER", cls, contentType, null, null);
        }
    }

    protected Object readBody(Response r, HttpURLConnection conn, Message outMessage, Class<?> cls, Type type, Annotation[] anns) {
        InputStream inputStream = (InputStream)r.getEntity();
        if (inputStream == null) {
            return cls == Response.class ? r : null;
        }
        try {
            Object length;
            int status = conn.getResponseCode();
            if (!(status >= 200 && status != 204 && status <= 300 || (length = r.getMetadata().getFirst((Object)"Content-Length")) != null && Integer.parseInt(length.toString()) != 0 && status < 400)) {
                return cls == Response.class ? r : (status >= 400 ? inputStream : null);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        MediaType contentType = AbstractClient.getResponseContentType(r);
        MessageBodyReader<?> mbr = ProviderFactory.getInstance(outMessage).createMessageBodyReader(cls, type, anns, contentType, outMessage);
        if (mbr != null) {
            try {
                return mbr.readFrom(cls, type, anns, contentType, new MetadataMap(r.getMetadata(), true, true), inputStream);
            }
            catch (Exception ex) {
                AbstractClient.reportMessageHandlerProblem("MSG_READER_PROBLEM", cls, contentType, ex, r);
            }
        } else {
            if (cls == Response.class) {
                return r;
            }
            AbstractClient.reportMessageHandlerProblem("NO_MSG_READER", cls, contentType, null, null);
        }
        return null;
    }

    protected static void addParametersToBuilder(UriBuilder ub, String paramName, Object pValue, ParameterType pt) {
        if (pt != ParameterType.MATRIX && pt != ParameterType.QUERY) {
            throw new IllegalArgumentException("This method currently deal with matrix and query parameters only");
        }
        if (!"".equals(paramName)) {
            if (InjectionUtils.isSupportedCollectionOrArray(pValue.getClass())) {
                List<Object> c = pValue.getClass().isArray() ? Arrays.asList((Object[])pValue) : (List<Object>)pValue;
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    AbstractClient.addToBuilder(ub, paramName, it.next(), pt);
                }
            } else {
                AbstractClient.addToBuilder(ub, paramName, pValue, pt);
            }
        } else {
            MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(pValue, "");
            for (Map.Entry entry : values.entrySet()) {
                for (Object v : (List)entry.getValue()) {
                    AbstractClient.addToBuilder(ub, (String)entry.getKey(), v, pt);
                }
            }
        }
    }

    private static void addToBuilder(UriBuilder ub, String paramName, Object pValue, ParameterType pt) {
        if (pt == ParameterType.MATRIX) {
            ub.matrixParam(paramName, new Object[]{pValue.toString()});
        } else {
            ub.queryParam(paramName, new Object[]{pValue.toString()});
        }
    }

    protected static void reportMessageHandlerProblem(String name, Class<?> cls, MediaType ct, Throwable cause, Response response) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, new Object[]{cls, ct.toString()});
        LOG.severe(errorMsg.toString());
        throw new ClientWebApplicationException(errorMsg.toString(), cause, response);
    }

    private static MediaType getResponseContentType(Response r) {
        MultivaluedMap map = r.getMetadata();
        if (map.containsKey((Object)"Content-Type")) {
            return MediaType.valueOf((String)map.getFirst((Object)"Content-Type").toString());
        }
        return MediaType.WILDCARD_TYPE;
    }

    protected static HttpURLConnection createHttpConnection(URI uri, String methodName) {
        try {
            URL url = uri.toURL();
            HttpURLConnection connect = (HttpURLConnection)url.openConnection();
            connect.setDoOutput(true);
            connect.setRequestMethod(methodName);
            return connect;
        }
        catch (Exception ex) {
            throw new ClientWebApplicationException("REMOTE_CONNECTION_PROBLEM", ex, null);
        }
    }

    protected static void setAllHeaders(MultivaluedMap<String, String> headers, HttpURLConnection conn) {
        for (Map.Entry entry : headers.entrySet()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                String value = (String)((List)entry.getValue()).get(i);
                b.append(value);
                if (i + 1 >= ((List)entry.getValue()).size()) continue;
                b.append(',');
            }
            conn.setRequestProperty((String)entry.getKey(), b.toString());
        }
    }

    protected ClientConfiguration getConfiguration() {
        return this.cfg;
    }

    protected void setConfiguration(ClientConfiguration config) {
        this.cfg = config;
    }

    protected void prepareConduitSelector(Message message) {
        block3: {
            try {
                this.cfg.prepareConduitSelector(message);
            }
            catch (Fault ex) {
                LOG.fine("Failure to prepare a message from conduit selector");
                if (!(ex.getCause() instanceof BusException)) break block3;
                String code = ((BusException)ex.getCause()).getCode();
                if ("NO_CONDUIT_INITIATOR".equals(code)) {
                    ConduitInitiatorManager cim = (ConduitInitiatorManager)this.cfg.getBus().getExtension(ConduitInitiatorManager.class);
                    ClientOnlyHTTPTransportFactory factory = new ClientOnlyHTTPTransportFactory();
                    factory.setBus(this.cfg.getBus());
                    cim.registerConduitInitiator(this.cfg.getConduitSelector().getEndpoint().getEndpointInfo().getTransportId(), (ConduitInitiator)factory);
                    this.cfg.prepareConduitSelector(message);
                }
                throw ex;
            }
        }
        message.getExchange().put(ConduitSelector.class, (Object)this.cfg.getConduitSelector());
    }

    protected static PhaseInterceptorChain setupOutInterceptorChain(ClientConfiguration cfg) {
        PhaseManager pm = (PhaseManager)cfg.getBus().getExtension(PhaseManager.class);
        List i1 = cfg.getBus().getOutInterceptors();
        List<Interceptor<? extends Message>> i2 = cfg.getOutInterceptors();
        List i3 = cfg.getConduitSelector().getEndpoint().getOutInterceptors();
        return new PhaseChainCache().get(pm.getOutPhases(), i1, i2, i3);
    }

    protected static PhaseInterceptorChain setupInInterceptorChain(ClientConfiguration cfg) {
        PhaseManager pm = (PhaseManager)cfg.getBus().getExtension(PhaseManager.class);
        List i1 = cfg.getBus().getInInterceptors();
        List<Interceptor<? extends Message>> i2 = cfg.getInInterceptors();
        List i3 = cfg.getConduitSelector().getEndpoint().getInInterceptors();
        return new PhaseChainCache().get(pm.getInPhases(), i1, i2, i3);
    }

    protected Message createSimpleMessage() {
        MessageImpl m = new MessageImpl();
        m.put((Object)Message.PROTOCOL_HEADERS, this.getHeaders());
        return m;
    }

    protected Message createMessage(String httpMethod, MultivaluedMap<String, String> headers, URI currentURI) {
        Message m = this.cfg.getConduitSelector().getEndpoint().getBinding().createMessage();
        m.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        m.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        m.put((Object)"org.apache.cxf.request.method", (Object)httpMethod);
        m.put((Object)Message.PROTOCOL_HEADERS, headers);
        m.put((Object)Message.ENDPOINT_ADDRESS, (Object)currentURI.toString());
        m.put((Object)"org.apache.cxf.request.uri", (Object)currentURI.toString());
        m.put((Object)"Content-Type", headers.getFirst((Object)"Content-Type"));
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.setSynchronous(true);
        exchange.setOutMessage(m);
        exchange.put(Bus.class, (Object)this.cfg.getBus());
        exchange.put(MessageObserver.class, (Object)new ClientMessageObserver(this.cfg));
        exchange.put(Endpoint.class, (Object)this.cfg.getConduitSelector().getEndpoint());
        exchange.setOneWay("true".equals(headers.getFirst((Object)"OnewayRequest")));
        exchange.put((Object)"org.apache.cxf.http.no_io_exceptions", (Object)true);
        m.setExchange((Exchange)exchange);
        PhaseInterceptorChain chain = AbstractClient.setupOutInterceptorChain(this.cfg);
        m.setInterceptorChain((InterceptorChain)chain);
        if (this.cfg.getRequestContext().size() > 0 || this.cfg.getResponseContext().size() > 0) {
            HashMap<String, Map<String, Object>> context = new HashMap<String, Map<String, Object>>();
            context.put(REQUEST_CONTEXT, this.cfg.getRequestContext());
            context.put(RESPONSE_CONTEXT, this.cfg.getResponseContext());
            m.put((Object)"org.apache.cxf.invocation.context", context);
            m.putAll(this.cfg.getRequestContext());
            exchange.putAll(this.cfg.getRequestContext());
            exchange.putAll(this.cfg.getResponseContext());
        }
        this.prepareConduitSelector(m);
        exchange.put(Service.class, (Object)this.cfg.getConduitSelector().getEndpoint().getService());
        return m;
    }

    protected void setEmptyRequestProperty(Message outMessage, String httpMethod) {
        if ("POST".equals(httpMethod)) {
            outMessage.put((Object)"org.apache.cxf.post.empty", (Object)true);
        }
    }

    protected void setPlainOperationNameProperty(Message outMessage, String name) {
        outMessage.getExchange().put((Object)"org.apache.cxf.resource.operation.name", (Object)name);
    }
}

