/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ext.logging.AbstractLoggingInterceptor;
import org.apache.cxf.ext.logging.WireTapIn;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrintWriterEventSender;
import org.apache.cxf.ext.logging.slf4j.Slf4jVerboseEventSender;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;

@NoJSR250Annotations
public class LoggingInInterceptor
extends AbstractLoggingInterceptor {
    public LoggingInInterceptor() {
        this(new Slf4jVerboseEventSender());
    }

    public LoggingInInterceptor(PrintWriter writer) {
        this(new PrintWriterEventSender(writer));
    }

    public LoggingInInterceptor(LogEventSender sender) {
        super("pre-invoke", sender);
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        ArrayList<PhaseInterceptor<? extends Message>> ret = new ArrayList<PhaseInterceptor<? extends Message>>();
        ret.add((PhaseInterceptor<? extends Message>)new WireTapIn(this.getWireTapLimit(), this.threshold));
        return ret;
    }

    public void handleMessage(Message message) throws Fault {
        if (LoggingInInterceptor.isLoggingDisabledNow(message)) {
            return;
        }
        this.createExchangeId(message);
        LogEvent event = new DefaultLogEventMapper().map(message);
        if (this.shouldLogContent(event)) {
            this.addContent(message, event);
        } else {
            event.setPayload("--- Content suppressed ---");
        }
        this.sender.send(event);
    }

    private void addContent(Message message, LogEvent event) {
        try {
            CachedOutputStream cos = (CachedOutputStream)message.getContent(CachedOutputStream.class);
            if (cos != null) {
                this.handleOutputStream(event, message, cos);
            } else {
                CachedWriter writer = (CachedWriter)message.getContent(CachedWriter.class);
                if (writer != null) {
                    this.handleWriter(event, writer);
                }
            }
        }
        catch (IOException e) {
            throw new Fault((Throwable)e);
        }
    }

    private void handleOutputStream(LogEvent event, Message message, CachedOutputStream cos) throws IOException {
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = StandardCharsets.UTF_8.name();
        }
        StringBuilder payload = new StringBuilder();
        cos.writeCacheTo(payload, encoding, (long)this.limit);
        cos.close();
        event.setPayload(payload.toString());
        boolean isTruncated = cos.size() > (long)this.limit && this.limit != -1;
        event.setTruncated(isTruncated);
        event.setFullContentFile(cos.getTempFile());
    }

    private void handleWriter(LogEvent event, CachedWriter writer) throws IOException {
        boolean isTruncated = writer.size() > (long)this.limit && this.limit != -1;
        StringBuilder payload = new StringBuilder();
        writer.writeCacheTo(payload, (long)this.limit);
        writer.close();
        event.setPayload(payload.toString());
        event.setTruncated(isTruncated);
        event.setFullContentFile(writer.getTempFile());
    }

    int getWireTapLimit() {
        if (this.limit == -1) {
            return -1;
        }
        if (this.limit == Integer.MAX_VALUE) {
            return this.limit;
        }
        return this.limit + 1;
    }
}

