/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.io.IOException;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ext.logging.AbstractLoggingInterceptor;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.message.Message;

@NoJSR250Annotations
public class LoggingInInterceptor
extends AbstractLoggingInterceptor {
    public LoggingInInterceptor(LogEventSender sender) {
        super("pre-invoke", sender);
    }

    public void handleMessage(Message message) throws Fault {
        this.createExchangeId(message);
        LogEvent event = new DefaultLogEventMapper().map(message);
        try {
            CachedOutputStream cos = (CachedOutputStream)message.getContent(CachedOutputStream.class);
            if (cos != null) {
                this.handleOutputStream(event, message, cos);
            } else {
                CachedWriter writer = (CachedWriter)message.getContent(CachedWriter.class);
                if (writer != null) {
                    this.handleWriter(event, writer);
                }
            }
        }
        catch (IOException e) {
            throw new Fault((Throwable)e);
        }
        this.sender.send(event);
    }

    private void handleOutputStream(LogEvent event, Message message, CachedOutputStream cos) throws IOException {
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        StringBuilder payload = new StringBuilder();
        cos.writeCacheTo(payload, encoding, (long)this.limit);
        cos.close();
        event.setPayload(payload.toString());
        boolean isTruncated = cos.size() > (long)this.limit && this.limit != -1;
        event.setTruncated(isTruncated);
        event.setFullContentFile(cos.getTempFile());
    }

    private void handleWriter(LogEvent event, CachedWriter writer) throws IOException {
        boolean isTruncated = writer.size() > (long)this.limit && this.limit != -1;
        StringBuilder payload = new StringBuilder();
        writer.writeCacheTo(payload, (long)this.limit);
        event.setPayload(payload.toString());
        event.setTruncated(isTruncated);
        event.setFullContentFile(writer.getTempFile());
    }
}

