/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.slf4j;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Slf4jEventSender
implements LogEventSender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(LogEvent event) {
        String cat = "org.apache.cxf.services." + event.getPortTypeName().getLocalPart() + "." + (Object)((Object)event.getType());
        Logger log = LoggerFactory.getLogger((String)cat);
        HashSet<String> keys = new HashSet<String>();
        try {
            this.put(keys, "Type", event.getType().toString());
            this.put(keys, "Address", event.getAddress());
            this.put(keys, "HttpMethod", event.getHttpMethod());
            this.put(keys, "Content-Type", event.getContentType());
            this.put(keys, "ResponseCode", event.getResponseCode());
            this.put(keys, "ExchangeId", event.getExchangeId());
            this.put(keys, "MessageId", event.getMessageId());
            if (event.getServiceName() != null) {
                this.put(keys, "ServiceName", this.localPart(event.getServiceName()));
                this.put(keys, "PortName", this.localPart(event.getPortName()));
                this.put(keys, "PortTypeName", this.localPart(event.getPortTypeName()));
            }
            if (event.getFullContentFile() != null) {
                this.put(keys, "FullContentFile", event.getFullContentFile().getAbsolutePath());
            }
            this.put(keys, "Headers", event.getHeaders().toString());
            log.info(this.getLogMessage(event));
        }
        finally {
            for (String key : keys) {
                MDC.remove((String)key);
            }
        }
    }

    private String localPart(QName name) {
        return name == null ? null : name.getLocalPart();
    }

    protected String getLogMessage(LogEvent event) {
        return event.getPayload();
    }

    private void put(Set<String> keys, String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
            keys.add(key);
        }
    }
}

