/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.javatowadl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.doc.DocumentationProvider;
import org.apache.cxf.jaxrs.model.wadl.WadlGenerator;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class Java2WADLMojo
extends AbstractMojo {
    public static final String WADL_NS = "http://wadl.dev.java.net/2009/02";
    private List<ClassResourceInfo> classResourceInfos = new ArrayList<ClassResourceInfo>();
    private String outputFile;
    private String address;
    private String docProvider;
    private String customWadlGenerator;
    private Boolean attachWadl;
    private String classifier;
    private List<String> classResourceNames;
    private String basePackages;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private boolean useJson;
    private boolean incrementNamespacePrefix;
    private boolean singleResourceMultipleMethods;
    private boolean useSingleSlashResource;
    private boolean includeDefaultWadlSchemaLocation;
    private boolean ignoreForwardSlash;
    private boolean addResourceAndMethodIds;
    private boolean linkAnyMediaTypeToXmlSchema;
    private boolean checkAbsolutePathSlash;
    private boolean ignoreOverloadedMethods;
    private boolean useJaxbContextForQnames;
    private boolean usePathParamsToCompareOperations;
    private boolean supportCollections;
    private boolean supportJaxbXmlType;
    private boolean supportJaxbSubstitutions;
    private String applicationTitle;
    private String namespacePrefix;
    private String outputFileName;
    private String outputFileExtension;
    private String stylesheetReference;
    private ClassLoader resourceClassLoader;

    public void execute() throws MojoExecutionException {
        System.setProperty("org.apache.cxf.JDKBugHacks.defaultUsesCaches", "true");
        List<Class<?>> resourceClasses = this.loadResourceClasses();
        this.initClassResourceInfoList(resourceClasses);
        WadlGenerator wadlGenerator = null;
        if (this.customWadlGenerator != null) {
            try {
                wadlGenerator = (WadlGenerator)this.getClassLoader().loadClass(this.customWadlGenerator).getConstructor(Bus.class).newInstance(this.getBus());
            }
            catch (Throwable e) {
                this.getLog().debug((CharSequence)"Custom WADLGenerator can not be created, using the default one");
            }
        }
        if (wadlGenerator == null) {
            wadlGenerator = new WadlGenerator(this.getBus());
        }
        if (this.docProvider != null) {
            try {
                DocumentationProvider documentationProvider = (DocumentationProvider)this.getClassLoader().loadClass(this.docProvider).getConstructor(String.class).newInstance(this.project.getBuild().getDirectory());
                wadlGenerator.setDocumentationProvider(documentationProvider);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        this.setExtraProperties(wadlGenerator);
        StringBuilder sbMain = wadlGenerator.generateWADL(this.getBaseURI(), this.classResourceInfos, this.useJson, null, null);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("the wadl is =====> \n" + sbMain.toString()));
        }
        this.generateWadl(resourceClasses, sbMain.toString());
    }

    private void setExtraProperties(WadlGenerator wg) {
        wg.setSingleResourceMultipleMethods(this.singleResourceMultipleMethods);
        wg.setIncrementNamespacePrefix(this.incrementNamespacePrefix);
        wg.setUseSingleSlashResource(this.useSingleSlashResource);
        wg.setIncludeDefaultWadlSchemaLocation(this.includeDefaultWadlSchemaLocation);
        wg.setIgnoreForwardSlash(this.ignoreForwardSlash);
        wg.setAddResourceAndMethodIds(this.addResourceAndMethodIds);
        wg.setLinkAnyMediaTypeToXmlSchema(this.linkAnyMediaTypeToXmlSchema);
        wg.setCheckAbsolutePathSlash(this.checkAbsolutePathSlash);
        wg.setIgnoreOverloadedMethods(this.ignoreOverloadedMethods);
        wg.setUseJaxbContextForQnames(this.useJaxbContextForQnames);
        wg.setUsePathParamsToCompareOperations(this.usePathParamsToCompareOperations);
        wg.setSupportCollections(this.supportCollections);
        wg.setSupportJaxbXmlType(this.supportJaxbXmlType);
        wg.setSupportJaxbSubstitutions(this.supportJaxbSubstitutions);
        if (this.applicationTitle != null) {
            wg.setApplicationTitle(this.applicationTitle);
        }
        if (this.namespacePrefix != null) {
            wg.setNamespacePrefix(this.namespacePrefix);
        }
        wg.setStylesheetReference(this.stylesheetReference);
    }

    private void generateWadl(List<Class<?>> resourceClasses, String wadl) throws MojoExecutionException {
        File wadlFile;
        if (this.outputFile == null && this.project != null) {
            String name = this.outputFileName != null ? this.outputFileName : (resourceClasses.size() == 1 ? resourceClasses.get(0).getSimpleName() : "application");
            this.outputFile = (this.project.getBuild().getDirectory() + "/generated/wadl/" + name + "." + this.outputFileExtension).replace('/', File.separatorChar);
        }
        try {
            FileUtils.mkDir((File)new File(this.outputFile).getParentFile());
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile));){
                writer.write(wadl);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (this.attachWadl.booleanValue() && this.outputFile != null && (wadlFile = new File(this.outputFile)).exists()) {
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, "wadl", this.classifier, wadlFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "wadl", wadlFile);
            }
        }
    }

    private String getBaseURI() {
        if (this.address != null) {
            return this.address;
        }
        return "/";
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        if (this.resourceClassLoader == null) {
            try {
                List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
                URL[] runtimeUrls = new URL[runtimeClasspathElements.size()];
                for (int i = 0; i < runtimeClasspathElements.size(); ++i) {
                    String element = (String)runtimeClasspathElements.get(i);
                    runtimeUrls[i] = new File(element).toURI().toURL();
                }
                this.resourceClassLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        return this.resourceClassLoader;
    }

    private List<Class<?>> loadResourceClasses() throws MojoExecutionException {
        if (this.classResourceNames == null && this.basePackages == null) {
            throw new MojoExecutionException("either classResourceNames or basePackages should be specified");
        }
        ArrayList resourceClasses = new ArrayList(this.classResourceNames == null ? 0 : this.classResourceNames.size());
        if (this.classResourceNames != null) {
            for (String className : this.classResourceNames) {
                try {
                    resourceClasses.add(this.getClassLoader().loadClass(className));
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
        }
        if (resourceClasses.isEmpty() && this.basePackages != null) {
            try {
                ArrayList<Class<Path>> anns = new ArrayList<Class<Path>>();
                anns.add(Path.class);
                Map discoveredClasses = ClasspathScanner.findClasses((Collection)ClasspathScanner.parsePackages((String)this.basePackages), anns, (ClassLoader)this.getClassLoader());
                if (discoveredClasses.containsKey(Path.class)) {
                    resourceClasses.addAll((Collection)discoveredClasses.get(Path.class));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resourceClasses;
    }

    private void initClassResourceInfoList(List<Class<?>> resourceClasses) throws MojoExecutionException {
        for (Class<?> beanClass : resourceClasses) {
            ClassResourceInfo cri = this.getCreatedFromModel(beanClass);
            if (cri != null) {
                if (!InjectionUtils.isConcreteClass((Class)cri.getServiceClass())) {
                    cri = new ClassResourceInfo(cri);
                    this.classResourceInfos.add(cri);
                }
                cri.setResourceClass(beanClass);
                continue;
            }
            cri = ResourceUtils.createClassResourceInfo(beanClass, beanClass, (boolean)true, (boolean)true, (Bus)this.getBus());
            if (cri == null) continue;
            this.classResourceInfos.add(cri);
        }
    }

    private Bus getBus() {
        return BusFactory.getDefaultBus();
    }

    private ClassResourceInfo getCreatedFromModel(Class<?> realClass) {
        for (ClassResourceInfo cri : this.classResourceInfos) {
            if (!cri.isCreatedFromModel() || !cri.isRoot() || !cri.getServiceClass().isAssignableFrom(realClass)) continue;
            return cri;
        }
        return null;
    }
}

