/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.javatowadl;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;

public final class DumpJavaDoc {
    private DumpJavaDoc() {
    }

    public static boolean start(RootDoc root) throws IOException {
        String dumpFileName = DumpJavaDoc.readOptions(root.options());
        OutputStream os = Files.newOutputStream(Paths.get(dumpFileName, new String[0]), new OpenOption[0]);
        Properties javaDocMap = new Properties();
        for (ClassDoc classDoc : root.classes()) {
            javaDocMap.put(classDoc.toString(), classDoc.commentText());
            for (MethodDoc method : classDoc.methods()) {
                javaDocMap.put(method.qualifiedName(), method.commentText());
                for (ParamTag paramTag : method.paramTags()) {
                    Parameter[] parameters = method.parameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        if (!parameters[i].name().equals(paramTag.parameterName())) continue;
                        javaDocMap.put(method.qualifiedName() + ".paramCommentTag." + i, paramTag.parameterComment());
                    }
                }
                Tag[] retTags = method.tags("return");
                if (retTags == null || retTags.length != 1) continue;
                Tag retTag = method.tags("return")[0];
                javaDocMap.put(method.qualifiedName() + ".returnCommentTag", retTag.text());
            }
        }
        javaDocMap.store(os, "");
        os.flush();
        os.close();
        return true;
    }

    private static String readOptions(String[][] options) {
        String tagName = null;
        for (int i = 0; i < options.length; ++i) {
            String[] opt = options[i];
            if (!opt[0].equals("-dumpJavaDocFile")) continue;
            tagName = opt[1];
        }
        return tagName;
    }

    public static int optionLength(String option) {
        if ("-dumpJavaDocFile".equals(option)) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean foundTagOption = false;
        for (int i = 0; i < options.length; ++i) {
            String[] opt = options[i];
            if (!opt[0].equals("-dumpJavaDocFile")) continue;
            if (foundTagOption) {
                reporter.printError("Only one -dumpJavaDocFile option allowed.");
                return false;
            }
            foundTagOption = true;
        }
        if (!foundTagOption) {
            reporter.printError("Usage: -dumpJavaDocFile theFileToDumpJavaDocForLatarUse...");
        }
        return foundTagOption;
    }
}

