/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentelemetry.TraceScope;
import org.apache.cxf.tracing.opentelemetry.internal.TextMapInjectAdapter;

public abstract class AbstractOpenTelemetryClientProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractOpenTelemetryClientProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.client.opentelemetry.span";
    private final Tracer tracer;
    private final OpenTelemetry openTelemetry;

    protected AbstractOpenTelemetryClientProvider(OpenTelemetry openTelemetry, String instrumentationName) {
        this(openTelemetry, openTelemetry.getTracer(instrumentationName));
    }

    protected AbstractOpenTelemetryClientProvider(OpenTelemetry openTelemetry, Tracer tracer) {
        this.openTelemetry = openTelemetry;
        this.tracer = tracer;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, URI uri, String method) {
        Context parentContext = Context.current();
        Span activeSpan = this.tracer.spanBuilder(this.buildSpanDescription(uri.toString(), method)).setParent(parentContext).setSpanKind(SpanKind.CLIENT).setAttribute(HttpAttributes.HTTP_REQUEST_METHOD, (Object)method).setAttribute(ServerAttributes.SERVER_ADDRESS, (Object)uri.getHost()).setAttribute(ServerAttributes.SERVER_PORT, (Object)uri.getPort()).setAttribute(UrlAttributes.URL_FULL, (Object)uri.toString()).setAttribute(NetworkAttributes.NETWORK_PEER_ADDRESS, (Object)uri.getHost()).setAttribute(NetworkAttributes.NETWORK_PEER_PORT, (Object)uri.getPort()).startSpan();
        Scope scope = activeSpan.makeCurrent();
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), requestHeaders, (TextMapSetter)TextMapInjectAdapter.get());
        Span span = null;
        if (this.isAsyncInvocation()) {
            span = activeSpan;
            scope.close();
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new TraceScope(activeSpan, scope, null), span != null);
    }

    private boolean isAsyncInvocation() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<TraceScope> holder, int responseStatus) {
        if (holder == null) {
            return;
        }
        TraceScope traceScope = (TraceScope)holder.getScope();
        if (traceScope != null) {
            Span span = traceScope.getSpan();
            Scope scope = traceScope.getScope();
            if (holder.isDetached()) {
                scope = span.makeCurrent();
            }
            if (responseStatus >= 300) {
                span.setAttribute(ErrorAttributes.ERROR_TYPE, (Object)String.valueOf(responseStatus));
            }
            span.setAttribute(HttpAttributes.HTTP_RESPONSE_STATUS_CODE.getKey(), (long)responseStatus);
            span.end();
            scope.close();
        }
    }

    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<TraceScope> holder, Throwable ex) {
        if (holder == null) {
            return;
        }
        TraceScope traceScope = (TraceScope)holder.getScope();
        if (traceScope != null) {
            Span span = traceScope.getSpan();
            Scope scope = traceScope.getScope();
            if (holder.isDetached()) {
                scope = span.makeCurrent();
            }
            span.setStatus(StatusCode.ERROR);
            if (ex != null) {
                span.recordException(ex);
            }
            span.end();
            scope.close();
        }
    }
}

