/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry.jaxrs;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import org.apache.cxf.tracing.opentelemetry.jaxrs.OpenTelemetryContextProvider;
import org.apache.cxf.tracing.opentelemetry.jaxrs.OpenTelemetryProvider;

@Provider
public class OpenTelemetryFeature
implements Feature {
    public static final String DEFAULT_INSTRUMENTATION_NAME = "org.apache.cxf";
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    public OpenTelemetryFeature() {
        this(GlobalOpenTelemetry.get());
    }

    public OpenTelemetryFeature(String instrumentationName) {
        this(GlobalOpenTelemetry.get(), instrumentationName);
    }

    public OpenTelemetryFeature(OpenTelemetry openTelemetry) {
        this(openTelemetry, DEFAULT_INSTRUMENTATION_NAME);
    }

    public OpenTelemetryFeature(OpenTelemetry openTelemetry, String instrumentationName) {
        this(openTelemetry, openTelemetry.getTracer(instrumentationName));
    }

    public OpenTelemetryFeature(OpenTelemetry openTelemetry, Tracer tracer) {
        this.openTelemetry = openTelemetry;
        this.tracer = tracer;
    }

    public boolean configure(FeatureContext context) {
        context.register((Object)new OpenTelemetryProvider(this.openTelemetry, this.tracer));
        context.register((Object)new OpenTelemetryContextProvider(this.tracer));
        return true;
    }
}

