/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.tracing.opentelemetry.OpenTelemetryClientStartInterceptor;
import org.apache.cxf.tracing.opentelemetry.OpenTelemetryClientStopInterceptor;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Client)
public class OpenTelemetryClientFeature
extends DelegatingFeature<Portable> {
    public OpenTelemetryClientFeature() {
        super((AbstractPortableFeature)new Portable());
    }

    public OpenTelemetryClientFeature(OpenTelemetry openTelemetry) {
        super((AbstractPortableFeature)new Portable(openTelemetry));
    }

    public OpenTelemetryClientFeature(OpenTelemetry openTelemetry, String instrumentationName) {
        super((AbstractPortableFeature)new Portable(openTelemetry, instrumentationName));
    }

    public OpenTelemetryClientFeature(OpenTelemetry openTelemetry, Tracer tracer) {
        super((AbstractPortableFeature)new Portable(openTelemetry, tracer));
    }

    public static class Portable
    implements AbstractPortableFeature {
        private final OpenTelemetryClientStartInterceptor out;
        private final OpenTelemetryClientStopInterceptor in;

        public Portable() {
            this(GlobalOpenTelemetry.get());
        }

        public Portable(OpenTelemetry openTelemetry) {
            this(openTelemetry, "org.apache.cxf");
        }

        public Portable(OpenTelemetry openTelemetry, String instrumentationName) {
            this.out = new OpenTelemetryClientStartInterceptor(openTelemetry, instrumentationName);
            this.in = new OpenTelemetryClientStopInterceptor(openTelemetry, instrumentationName);
        }

        public Portable(OpenTelemetry openTelemetry, Tracer tracer) {
            this.out = new OpenTelemetryClientStartInterceptor(openTelemetry, tracer);
            this.in = new OpenTelemetryClientStopInterceptor(openTelemetry, tracer);
        }

        public void doInitializeProvider(InterceptorProvider provider, Bus bus) {
            provider.getInInterceptors().add(this.in);
            provider.getOutInterceptors().add(this.out);
        }
    }
}

