/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.concurrent.Callable;
import org.apache.cxf.tracing.Traceable;
import org.apache.cxf.tracing.TracerContext;
import org.apache.cxf.tracing.opentelemetry.ScopedSpan;

public class OpenTelemetryContext
implements TracerContext {
    private final Tracer tracer;
    private final Span continuation;

    public OpenTelemetryContext(Tracer tracer) {
        this(tracer, null);
    }

    public OpenTelemetryContext(Tracer tracer, Span continuation) {
        this.tracer = tracer;
        this.continuation = continuation;
    }

    public Scope startSpan(String description) {
        return this.newOrChildSpan(description, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T continueSpan(Traceable<T> traceable) throws Exception {
        Scope scope = null;
        if (Span.current() != null && this.continuation != null && !Span.current().getSpanContext().getSpanId().equals(this.continuation.getSpanContext().getSpanId())) {
            scope = this.continuation.makeCurrent();
        }
        try {
            Object object = traceable.call((TracerContext)new OpenTelemetryContext(this.tracer));
            return (T)object;
        }
        finally {
            if (this.continuation != null && scope != null) {
                scope.close();
            }
        }
    }

    public <T> Callable<T> wrap(String description, final Traceable<T> traceable) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return traceable.call((TracerContext)new OpenTelemetryContext(OpenTelemetryContext.this.tracer));
            }
        };
        Context parent = Context.current();
        return () -> {
            try (Scope scope = this.newOrChildSpan(description, parent);){
                Object v = callable.call();
                return v;
            }
        };
    }

    public void annotate(String key, String value) {
        Span current = Span.current();
        if (current != null) {
            current.setAttribute(key, value);
        }
    }

    public void timeline(String message) {
        Span current = Span.current();
        if (current != null) {
            current.addEvent(message);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (Tracer.class.equals(clazz)) {
            return (T)this.tracer;
        }
        throw new IllegalArgumentException("The class is '" + String.valueOf(clazz) + "'not supported and cannot be unwrapped");
    }

    private Scope newOrChildSpan(String description, Context parent) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(description);
        if (parent != null) {
            spanBuilder.setParent(parent);
        }
        Span span = spanBuilder.startSpan();
        return new ScopedSpan(span, span.makeCurrent());
    }
}

