/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.semconv.ClientAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.UserAgentAttributes;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentelemetry.AbstractOpenTelemetryInterceptor;
import org.apache.cxf.tracing.opentelemetry.TraceScope;

@NoJSR250Annotations
public class OpenTelemetryStartInterceptor
extends AbstractOpenTelemetryInterceptor {
    public OpenTelemetryStartInterceptor(OpenTelemetry openTelemetry, String instrumentationName) {
        super("pre-invoke", openTelemetry, instrumentationName);
    }

    public OpenTelemetryStartInterceptor(OpenTelemetry openTelemetry, Tracer tracer) {
        super("pre-invoke", openTelemetry, tracer);
    }

    public void handleMessage(Message message) throws Fault {
        HttpServletRequest request;
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan(headers, OpenTelemetryStartInterceptor.getUri((Message)message), (String)message.get((Object)"org.apache.cxf.request.method"));
        if (holder != null) {
            message.getExchange().put((Object)"org.apache.cxf.tracing.opentelemetry.span", holder);
        }
        if ((request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST")) != null) {
            String userAgent;
            Span span = ((TraceScope)holder.getScope()).getSpan();
            span.setAttribute(ClientAttributes.CLIENT_ADDRESS, (Object)request.getRemoteAddr());
            span.setAttribute(ClientAttributes.CLIENT_PORT, request.getRemotePort());
            span.setAttribute(NetworkAttributes.NETWORK_PEER_ADDRESS, (Object)request.getRemoteAddr());
            span.setAttribute(NetworkAttributes.NETWORK_PEER_PORT, request.getRemotePort());
            String protocol = request.getProtocol();
            if (protocol != null && protocol.contains("/")) {
                String protocolVersion = protocol.split("/")[1];
                span.setAttribute(NetworkAttributes.NETWORK_PROTOCOL_VERSION, (Object)protocolVersion);
            }
            if ((userAgent = request.getHeader("User-Agent")) != null) {
                span.setAttribute(UserAgentAttributes.USER_AGENT_ORIGINAL, (Object)userAgent);
            }
        }
    }
}

