/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry.jaxrs;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.semconv.ClientAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.UserAgentAttributes;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentelemetry.AbstractOpenTelemetryProvider;
import org.apache.cxf.tracing.opentelemetry.TraceScope;

@Provider
public class OpenTelemetryProvider
extends AbstractOpenTelemetryProvider
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest request;

    public OpenTelemetryProvider(OpenTelemetry openTelemetry, String instrumentationName) {
        super(openTelemetry, instrumentationName);
    }

    public OpenTelemetryProvider(OpenTelemetry openTelemetry, Tracer tracer) {
        super(openTelemetry, tracer);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan((Map<String, List<String>>)requestContext.getHeaders(), requestContext.getUriInfo().getRequestUri(), requestContext.getMethod());
        if (this.request != null) {
            String userAgent;
            Span span = ((TraceScope)holder.getScope()).getSpan();
            span.setAttribute(ClientAttributes.CLIENT_ADDRESS, (Object)this.request.getRemoteAddr());
            span.setAttribute(ClientAttributes.CLIENT_PORT, this.request.getRemotePort());
            span.setAttribute(NetworkAttributes.NETWORK_PEER_ADDRESS, (Object)this.request.getRemoteAddr());
            span.setAttribute(NetworkAttributes.NETWORK_PEER_PORT, this.request.getRemotePort());
            String protocol = this.request.getProtocol();
            if (protocol != null && protocol.contains("/")) {
                String protocolVersion = protocol.split("/")[1];
                span.setAttribute(NetworkAttributes.NETWORK_PROTOCOL_VERSION, (Object)protocolVersion);
            }
            if ((userAgent = this.request.getHeader("User-Agent")) != null) {
                span.setAttribute(UserAgentAttributes.USER_AGENT_ORIGINAL, (Object)userAgent);
            }
        }
        if (holder != null) {
            requestContext.setProperty("org.apache.cxf.tracing.opentelemetry.span", holder);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        super.stopTraceSpan((Map<String, List<String>>)requestContext.getHeaders(), (Map<String, List<Object>>)responseContext.getHeaders(), responseContext.getStatus(), (AbstractTracingProvider.TraceScopeHolder<TraceScope>)((AbstractTracingProvider.TraceScopeHolder)requestContext.getProperty("org.apache.cxf.tracing.opentelemetry.span")));
    }

    @Override
    protected boolean isAsyncResponse() {
        Annotation[][] annotationArray = this.resourceInfo.getResourceMethod().getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().equals(Suspended.class)) continue;
                return true;
            }
        }
        return false;
    }
}

