/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.brave.TraceScope;
import org.apache.cxf.tracing.brave.internal.HttpAdapterFactory;
import org.apache.cxf.tracing.brave.internal.HttpClientAdapterFactory;

public abstract class AbstractBraveClientProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractBraveClientProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.client.brave.span";
    private final HttpTracing brave;

    public AbstractBraveClientProvider(HttpTracing brave) {
        this.brave = brave;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, URI uri, String method) {
        HttpAdapterFactory.Request request = HttpAdapterFactory.request(requestHeaders, uri, method);
        HttpClientRequest wrapper = HttpClientAdapterFactory.create(request);
        HttpClientHandler handler = HttpClientHandler.create((HttpTracing)this.brave);
        Span span = handler.handleSend(wrapper);
        Tracer.SpanInScope scope = null;
        if (!this.isAsyncInvocation() && span != null) {
            scope = this.brave.tracing().tracer().withSpanInScope(span);
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new TraceScope(span, scope), scope == null);
    }

    private boolean isAsyncInvocation() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<TraceScope> holder, String method, URI uri, int responseStatus) {
        if (holder == null) {
            return;
        }
        TraceScope scope = (TraceScope)holder.getScope();
        if (scope != null) {
            try {
                if (holder.isDetached()) {
                    this.brave.tracing().tracer().joinSpan(scope.getSpan().context());
                }
                HttpAdapterFactory.Response response = HttpAdapterFactory.response(method, uri.toASCIIString(), responseStatus);
                HttpClientResponse wrapper = HttpClientAdapterFactory.create(response);
                HttpClientHandler handler = HttpClientHandler.create((HttpTracing)this.brave);
                handler.handleReceive(wrapper, scope.getSpan());
            }
            finally {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<TraceScope> holder, String method, URI uri, Throwable ex) {
        if (holder == null) {
            return;
        }
        TraceScope scope = (TraceScope)holder.getScope();
        if (scope != null) {
            try {
                if (holder.isDetached()) {
                    this.brave.tracing().tracer().joinSpan(scope.getSpan().context());
                }
                HttpClientResponse wrapper = HttpClientAdapterFactory.create(method, uri, ex);
                HttpClientHandler handler = HttpClientHandler.create((HttpTracing)this.brave);
                handler.handleReceive(wrapper, scope.getSpan());
            }
            finally {
                scope.close();
            }
        }
    }
}

