/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpTracing;
import java.util.concurrent.Callable;
import org.apache.cxf.tracing.Traceable;
import org.apache.cxf.tracing.TracerContext;
import org.apache.cxf.tracing.brave.TraceScope;

public class BraveTracerContext
implements TracerContext {
    private final HttpTracing brave;
    private final Tracer tracer;
    private final Span continuationSpan;

    public BraveTracerContext(HttpTracing brave) {
        this(brave, null);
    }

    public BraveTracerContext(HttpTracing brave, Span continuationSpan) {
        this.brave = brave;
        this.tracer = brave.tracing().tracer();
        this.continuationSpan = continuationSpan;
    }

    public TraceScope startSpan(String description) {
        return new TraceScope(this.brave, this.tracer.nextSpan().name(description).start());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T continueSpan(Traceable<T> traceable) throws Exception {
        Tracer.SpanInScope scope = null;
        if (this.tracer.currentSpan() == null && this.continuationSpan != null) {
            scope = this.tracer.withSpanInScope(this.continuationSpan);
        }
        try {
            Object object = traceable.call((TracerContext)new BraveTracerContext(this.brave));
            return (T)object;
        }
        finally {
            if (this.continuationSpan != null && scope != null) {
                scope.close();
            }
        }
    }

    public <T> Callable<T> wrap(String description, final Traceable<T> traceable) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return traceable.call((TracerContext)new BraveTracerContext(BraveTracerContext.this.brave));
            }
        };
        Span parent = this.tracer.currentSpan();
        return () -> {
            try (TraceScope span = this.newOrChildSpan(description, parent);){
                Object v = callable.call();
                return v;
            }
        };
    }

    public void annotate(String key, String value) {
        Span current = this.tracer.currentSpan();
        if (current != null) {
            current.tag(key, value);
        }
    }

    public void timeline(String message) {
        Span current = this.tracer.currentSpan();
        if (current != null) {
            current.annotate(message);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (HttpTracing.class.equals(clazz)) {
            return (T)this.brave;
        }
        if (Tracing.class.equals(clazz)) {
            return (T)this.brave.tracing();
        }
        if (Tracer.class.equals(clazz)) {
            return (T)this.tracer;
        }
        throw new IllegalArgumentException("The class is '" + String.valueOf(clazz) + "'not supported and cannot be unwrapped");
    }

    private TraceScope newOrChildSpan(String description, Span parent) {
        if (parent == null) {
            return new TraceScope(this.brave, this.tracer.newTrace().name(description).start());
        }
        return new TraceScope(this.brave, this.tracer.newChild(parent.context()).name(description).start());
    }
}

