/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ResourceBundle;
import javax.jws.WebService;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.connector.Connection;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jca.core.resourceadapter.AbstractManagedConnectionImpl;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;
import org.apache.cxf.jca.cxf.CXFConnectionRequestInfo;
import org.apache.cxf.jca.cxf.CXFInvocationHandler;
import org.apache.cxf.jca.cxf.CXFManagedConnection;
import org.apache.cxf.jca.cxf.CXFManagedConnectionFactory;
import org.apache.cxf.jca.cxf.CXFManagedConnectionMetaData;
import org.apache.cxf.jca.cxf.CXFTransaction;
import org.apache.cxf.jca.cxf.ConnectionFactoryImpl;
import org.apache.cxf.jca.cxf.ManagedConnectionFactoryImpl;
import org.apache.cxf.jca.cxf.handlers.InvocationHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedConnectionImpl
extends AbstractManagedConnectionImpl
implements CXFManagedConnection,
Connection {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ConnectionFactoryImpl.class);
    private InvocationHandlerFactory handlerFactory;
    private Object cxfService;
    private boolean connectionHandleActive;

    public ManagedConnectionImpl(ManagedConnectionFactoryImpl managedFactory, ConnectionRequestInfo crInfo, Subject subject) throws ResourceException {
        super(managedFactory, crInfo, subject);
    }

    @Override
    public void associateConnection(Object connection) throws ResourceException {
        try {
            CXFInvocationHandler handler = (CXFInvocationHandler)Proxy.getInvocationHandler(connection);
            CXFManagedConnection managedConnection = handler.getData().getManagedConnection();
            if (managedConnection != this) {
                handler.getData().setManagedConnection(this);
                ((ManagedConnectionImpl)managedConnection).disassociateConnectionHandle(connection);
                if (this.getCXFService() == null) {
                    this.cxfService = connection;
                    this.connectionHandleActive = true;
                }
            }
        }
        catch (Exception ex) {
            throw new ResourceAdapterInternalException(new Message("ASSOCIATED_ERROR", BUNDLE, new Object[0]).toString(), ex);
        }
    }

    @Override
    public CXFManagedConnectionFactory getManagedConnectionFactory() {
        return (ManagedConnectionFactoryImpl)this.theManagedConnectionFactory();
    }

    public Object getCXFService() {
        return this.cxfService;
    }

    private void initializeCXFConnection(ConnectionRequestInfo crInfo, Subject subject) throws ResourceException {
        this.crinfo = crInfo;
        this.subject = subject;
        this.cxfService = this.getCXFConnection(subject, crInfo);
    }

    @Override
    public Object getConnection(Subject subject, ConnectionRequestInfo crInfo) throws ResourceException {
        Object connection = null;
        if (this.getCXFService() == null) {
            this.initializeCXFConnection(crInfo, subject);
            connection = this.getCXFService();
        } else {
            connection = !this.connectionHandleActive && this.crinfo.equals(crInfo) ? this.getCXFService() : this.getCXFConnection(subject, crInfo);
        }
        this.connectionHandleActive = true;
        return connection;
    }

    public synchronized Object getCXFConnection(Subject subject, ConnectionRequestInfo crInfo) throws ResourceException {
        CXFConnectionRequestInfo requestInfo = (CXFConnectionRequestInfo)crInfo;
        Class<?> serviceInterface = requestInfo.getInterface();
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Object factoryBean = null;
            factoryBean = this.isJaxWsServiceInterface(serviceInterface) ? new JaxWsProxyFactoryBean() : new ClientProxyFactoryBean();
            factoryBean.setServiceClass(serviceInterface);
            if (requestInfo.getServiceName() != null) {
                factoryBean.getServiceFactory().setServiceName(requestInfo.getServiceName());
            }
            if (requestInfo.getPortName() != null) {
                factoryBean.getServiceFactory().setEndpointName(requestInfo.getPortName());
            }
            if (requestInfo.getWsdlLocation() != null) {
                factoryBean.getServiceFactory().setWsdlURL(requestInfo.getWsdlLocation());
            }
            if (requestInfo.getAddress() != null) {
                factoryBean.setAddress(requestInfo.getAddress());
            }
            Object obj = factoryBean.create();
            this.setSubject(subject);
            Object object = this.createConnectionProxy(obj, requestInfo, subject);
            return object;
        }
        catch (WebServiceException wse) {
            throw new ResourceAdapterInternalException(new Message("FAILED_TO_GET_CXF_CONNECTION", BUNDLE, new Object[]{requestInfo}).toString(), wse);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    @Override
    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new CXFManagedConnectionMetaData();
    }

    private boolean isJaxWsServiceInterface(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return null != cls.getAnnotation(WebService.class);
    }

    @Override
    public boolean isBound() {
        return this.getCXFService() != null;
    }

    @Override
    public void close() throws ResourceException {
    }

    void disassociateConnectionHandle(Object handle) {
        if (this.cxfService == handle) {
            this.connectionHandleActive = false;
            this.cxfService = null;
        }
    }

    private Object createConnectionProxy(Object obj, CXFConnectionRequestInfo cri, Subject subject) throws ResourceException {
        Class[] classes = new Class[]{Connection.class, BindingProvider.class, cri.getInterface()};
        return Proxy.newProxyInstance(cri.getInterface().getClassLoader(), classes, this.createInvocationHandler(obj, subject));
    }

    private InvocationHandler createInvocationHandler(Object obj, Subject subject) throws ResourceException {
        return this.getHandlerFactory().createHandlers(obj, subject);
    }

    private InvocationHandlerFactory getHandlerFactory() throws ResourceException {
        if (this.handlerFactory == null) {
            this.handlerFactory = new InvocationHandlerFactory(this.getBus(), this);
        }
        return this.handlerFactory;
    }

    private Bus getBus() {
        return ((ManagedConnectionFactoryImpl)this.getManagedConnectionFactory()).getBus();
    }

    @Override
    public void close(Object closingHandle) throws ResourceException {
        if (closingHandle == this.cxfService) {
            this.connectionHandleActive = false;
        }
        super.close(closingHandle);
    }

    @Override
    public void destroy() throws ResourceException {
        this.connectionHandleActive = false;
        this.cxfService = null;
        super.destroy();
    }

    @Override
    public CXFTransaction getCXFTransaction() {
        return null;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException();
    }
}

