/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.core.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.jarloader.JarLoader;

public final class PlugInClassLoaderHelper {
    private static final Logger LOG = LogUtils.getL7dLogger(PlugInClassLoaderHelper.class);
    private static Map<String, byte[]> nonClassesMap = new HashMap<String, byte[]>();

    private PlugInClassLoaderHelper() {
    }

    public static boolean hasResource(String name) {
        try {
            return PlugInClassLoaderHelper.getResourceAsBytes(name) != null;
        }
        catch (IOException ex) {
            LOG.fine("unexpected exception: " + ex);
            return false;
        }
    }

    public static byte[] getResourceAsBytes(String name) throws IOException {
        if (!name.endsWith(".class") && nonClassesMap.containsKey(name)) {
            return nonClassesMap.get(name);
        }
        if (!PlugInClassLoaderHelper.isJarReference(name)) {
            try {
                return JarLoader.getBytesFromInputStream(new URL(name).openStream());
            }
            catch (MalformedURLException mue) {
                throw new IOException(mue.getMessage());
            }
        }
        if (PlugInClassLoaderHelper.isNestedDirectoryReference(name)) {
            throw new IOException("Accessing contents of directories within jars is currently not supported");
        }
        String enclosingJar = name.substring(0, name.lastIndexOf("!/") + 2);
        String resourceName = name.substring(name.lastIndexOf("!/") + 2);
        Map jarMap = JarLoader.getJarContents(enclosingJar);
        if (null != jarMap && jarMap.containsKey(resourceName)) {
            byte[] bytes = (byte[])jarMap.get(resourceName);
            if (!name.endsWith(".class")) {
                nonClassesMap.put(name, bytes);
            }
            return bytes;
        }
        return null;
    }

    private static boolean isJarReference(String name) {
        return name.indexOf("!/") != -1;
    }

    private static boolean isNestedDirectoryReference(String path) {
        String nestedDir = path.substring(path.lastIndexOf("!/") + 2);
        return !"".equals(nestedDir) && nestedDir.endsWith("/");
    }
}

