/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.xml.EncryptionProperties;
import org.apache.cxf.rs.security.xml.SignatureProperties;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.OutboundXMLSec;
import org.apache.xml.security.stax.ext.SecurePart;
import org.apache.xml.security.stax.ext.XMLSec;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;

public class XmlSecOutInterceptor
implements PhaseInterceptor<Message> {
    public static final String OUTPUT_STREAM_HOLDER = XmlSecOutInterceptor.class.getName() + ".outputstream";
    private static final Logger LOG = LogUtils.getL7dLogger(XmlSecOutInterceptor.class);
    private XmlSecStaxOutInterceptorInternal ending;
    private Set<String> before = new HashSet<String>();
    private Set<String> after = new HashSet<String>();
    private EncryptionProperties encryptionProperties = new EncryptionProperties();
    private SignatureProperties sigProps = new SignatureProperties();
    private String phase;
    private boolean encryptSymmetricKey = true;
    private SecretKey symmetricKey;
    private boolean signRequest;
    private boolean encryptRequest;
    private List<QName> elementsToSign = new ArrayList<QName>();
    private List<QName> elementsToEncrypt = new ArrayList<QName>();
    private boolean keyInfoMustBeAvailable = true;

    public XmlSecOutInterceptor() {
        this.setPhase("pre-stream");
        this.getBefore().add(StaxOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    @Override
    public void handleFault(Message message) {
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        OutputStream os = message.getContent(OutputStream.class);
        String encoding = this.getEncoding(message);
        if (!this.encryptRequest && !this.signRequest) {
            Exception ex = new Exception("Either encryption and/or signature must be enabled");
            this.throwFault(ex.getMessage(), ex);
        }
        XMLStreamWriter newXMLStreamWriter = null;
        try {
            XMLSecurityProperties properties = new XMLSecurityProperties();
            if (this.signRequest) {
                this.configureSignature(message, properties);
            }
            if (this.encryptRequest) {
                this.configureEncryption(message, properties);
            }
            OutboundXMLSec outboundXMLSec = XMLSec.getOutboundXMLSec((XMLSecurityProperties)properties);
            newXMLStreamWriter = outboundXMLSec.processOutMessage(os, encoding);
            message.setContent(XMLStreamWriter.class, newXMLStreamWriter);
        }
        catch (XMLSecurityException e) {
            this.throwFault(e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            this.throwFault(e.getMessage(), e);
        }
        message.put("disable.outputstream.optimization", Boolean.TRUE);
        message.put("org.apache.cxf.stax.force-start-document", Boolean.TRUE);
        if (MessageUtils.getContextualBoolean(message, "org.apache.cxf.stax.force-start-document", false)) {
            try {
                newXMLStreamWriter.writeStartDocument(encoding, "1.0");
            }
            catch (XMLStreamException e) {
                throw new Fault(e);
            }
            message.removeContent(OutputStream.class);
            message.put(OUTPUT_STREAM_HOLDER, os);
        }
        message.getInterceptorChain().add(this.ending);
    }

    private void configureEncryption(Message message, XMLSecurityProperties properties) throws Exception {
        if (this.elementsToEncrypt == null || this.elementsToEncrypt.isEmpty()) {
            throw new Exception("An Element to Encrypt must be specified");
        }
        properties.setEncryptionSymAlgorithm(this.encryptionProperties.getEncryptionSymmetricKeyAlgo());
        properties.setEncryptionKey((Key)this.getSymmetricKey(this.encryptionProperties.getEncryptionSymmetricKeyAlgo()));
        if (this.encryptSymmetricKey) {
            String userName = (String)message.getContextualProperty("ws-security.encryption.username");
            CryptoLoader loader = new CryptoLoader();
            Crypto crypto = loader.getCrypto(message, "ws-security.encryption.crypto", "ws-security.encryption.properties");
            userName = SecurityUtils.getUserName(crypto, userName);
            if (StringUtils.isEmpty(userName)) {
                throw new Exception("User name is not available");
            }
            X509Certificate sendingCert = this.getCertificateFromCrypto(crypto, userName);
            if (sendingCert == null) {
                throw new Exception("Sending certificate is not available");
            }
            properties.setEncryptionUseThisCertificate(sendingCert);
            if (this.encryptionProperties.getEncryptionKeyTransportAlgo() != null) {
                properties.setEncryptionKeyTransportAlgorithm(this.encryptionProperties.getEncryptionKeyTransportAlgo());
            }
            if (this.encryptionProperties.getEncryptionDigestAlgo() != null) {
                properties.setEncryptionKeyTransportDigestAlgorithm(this.encryptionProperties.getEncryptionDigestAlgo());
            }
        }
        properties.addAction(XMLSecurityConstants.ENCRYPT);
        SecurePart securePart = new SecurePart(this.elementsToEncrypt.get(0), SecurePart.Modifier.Element);
        properties.addEncryptionPart(securePart);
    }

    private X509Certificate getCertificateFromCrypto(Crypto crypto, String user) throws Exception {
        X509Certificate[] certs = SecurityUtils.getCertificates(crypto, user);
        return certs[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getSymmetricKey(String symEncAlgo) throws Exception {
        XmlSecOutInterceptor xmlSecOutInterceptor = this;
        synchronized (xmlSecOutInterceptor) {
            if (this.symmetricKey == null) {
                KeyGenerator keyGen = this.getKeyGenerator(symEncAlgo);
                this.symmetricKey = keyGen.generateKey();
            }
            return this.symmetricKey;
        }
    }

    private KeyGenerator getKeyGenerator(String symEncAlgo) throws WSSecurityException {
        try {
            String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)symEncAlgo);
            KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
            if (symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes128-gcm")) {
                keyGen.init(128);
            } else if (symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes192-gcm")) {
                keyGen.init(192);
            } else if (symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes256-gcm")) {
                keyGen.init(256);
            }
            return keyGen;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)e);
        }
    }

    private void configureSignature(Message message, XMLSecurityProperties properties) throws Exception {
        if (this.elementsToSign == null || this.elementsToSign.isEmpty()) {
            throw new Exception("An Element to Sign must be specified");
        }
        String userNameKey = "ws-security.signature.username";
        CryptoLoader loader = new CryptoLoader();
        Crypto crypto = loader.getCrypto(message, "ws-security.signature.crypto", "ws-security.signature.properties");
        String user = SecurityUtils.getUserName(message, crypto, userNameKey);
        if (StringUtils.isEmpty(user) || "useReqSigCert".equals(user)) {
            throw new Exception("User name is not available");
        }
        String password = SecurityUtils.getPassword(message, user, 3, this.getClass());
        X509Certificate[] issuerCerts = SecurityUtils.getCertificates(crypto, user);
        properties.setSignatureCerts(issuerCerts);
        String sigAlgo = this.sigProps.getSignatureAlgo() == null ? "http://www.w3.org/2000/09/xmldsig#rsa-sha1" : this.sigProps.getSignatureAlgo();
        String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
        if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        properties.setSignatureAlgorithm(sigAlgo);
        PrivateKey privateKey = null;
        try {
            privateKey = crypto.getPrivateKey(user, password);
        }
        catch (Exception ex) {
            String errorMessage = "Private key can not be loaded, user:" + user;
            LOG.severe(errorMessage);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
        }
        properties.setSignatureKey((Key)privateKey);
        String digestAlgo = this.sigProps.getSignatureDigestAlgo() == null ? "http://www.w3.org/2000/09/xmldsig#sha1" : this.sigProps.getSignatureDigestAlgo();
        properties.setSignatureDigestAlgorithm(digestAlgo);
        if (this.keyInfoMustBeAvailable) {
            properties.setSignatureKeyIdentifier(XmlSecOutInterceptor.convertKeyIdentifier(this.sigProps.getSignatureKeyIdType()));
        } else {
            properties.setSignatureKeyIdentifier(SecurityTokenConstants.KeyIdentifier_NoKeyInfo);
        }
        String c14nMethod = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        if (this.sigProps.getSignatureC14nMethod() != null) {
            c14nMethod = this.sigProps.getSignatureC14nMethod();
        }
        properties.setSignatureCanonicalizationAlgorithm(c14nMethod);
        properties.addAction(XMLSecurityConstants.SIGNATURE);
        String transform = "http://www.w3.org/2001/10/xml-exc-c14n#";
        if (this.sigProps.getSignatureC14nTransform() != null) {
            transform = this.sigProps.getSignatureC14nTransform();
        }
        SecurePart securePart = new SecurePart(this.elementsToSign.get(0), SecurePart.Modifier.Element, new String[]{"http://www.w3.org/2000/09/xmldsig#enveloped-signature", transform}, digestAlgo);
        properties.addSignaturePart(securePart);
    }

    protected void throwFault(String error, Exception ex) {
        LOG.warning(error);
        Response response = JAXRSUtils.toResponseBuilder(400).entity((Object)error).build();
        throw ExceptionUtils.toBadRequestException(null, response);
    }

    @Override
    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    @Override
    public Set<String> getAfter() {
        return this.after;
    }

    public void setAfter(Set<String> after) {
        this.after = after;
    }

    @Override
    public Set<String> getBefore() {
        return this.before;
    }

    public void setBefore(Set<String> before) {
        this.before = before;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public void setEncryptionProperties(EncryptionProperties properties) {
        this.encryptionProperties = properties;
    }

    public void setKeyIdentifierType(String type) {
        this.encryptionProperties.setEncryptionKeyIdType(type);
    }

    public void setSymmetricEncAlgorithm(String algo) {
        if (!algo.startsWith("http://www.w3.org/2001/04/xmlenc#") && !algo.startsWith("http://www.w3.org/2009/xmlenc11#")) {
            algo = "http://www.w3.org/2001/04/xmlenc#" + algo;
        }
        this.encryptionProperties.setEncryptionSymmetricKeyAlgo(algo);
    }

    public void setKeyEncAlgorithm(String algo) {
        this.encryptionProperties.setEncryptionKeyTransportAlgo(algo);
    }

    public void setEncryptionDigestAlgorithm(String algo) {
        this.encryptionProperties.setEncryptionDigestAlgo(algo);
    }

    public void setKeyInfoMustBeAvailable(boolean use) {
        this.keyInfoMustBeAvailable = use;
    }

    public void setSignatureProperties(SignatureProperties props) {
        this.sigProps = props;
    }

    public void setSignatureAlgorithm(String algo) {
        this.sigProps.setSignatureAlgo(algo);
    }

    public void setSignatureDigestAlgorithm(String algo) {
        this.sigProps.setSignatureDigestAlgo(algo);
    }

    public final XmlSecStaxOutInterceptorInternal createEndingInterceptor() {
        return new XmlSecStaxOutInterceptorInternal();
    }

    private String getEncoding(Message message) {
        Exchange ex = message.getExchange();
        String encoding = (String)message.get(Message.ENCODING);
        if (encoding == null && ex.getInMessage() != null) {
            encoding = (String)ex.getInMessage().get(Message.ENCODING);
            message.put(Message.ENCODING, encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
            message.put(Message.ENCODING, encoding);
        }
        return encoding;
    }

    private static SecurityTokenConstants.KeyIdentifier convertKeyIdentifier(String keyIdentifier) {
        if ("IssuerSerial".equals(keyIdentifier)) {
            return SecurityTokenConstants.KeyIdentifier_IssuerSerial;
        }
        if ("X509KeyIdentifier".equals(keyIdentifier)) {
            return SecurityTokenConstants.KeyIdentifier_X509KeyIdentifier;
        }
        if ("SKIKeyIdentifier".equals(keyIdentifier)) {
            return SecurityTokenConstants.KeyIdentifier_SkiKeyIdentifier;
        }
        if ("KeyValue".equals(keyIdentifier)) {
            return SecurityTokenConstants.KeyIdentifier_KeyValue;
        }
        return SecurityTokenConstants.KeyIdentifier_X509KeyIdentifier;
    }

    public boolean isSignRequest() {
        return this.signRequest;
    }

    public void setSignRequest(boolean signRequest) {
        this.signRequest = signRequest;
    }

    public boolean isEncryptRequest() {
        return this.encryptRequest;
    }

    public void setEncryptRequest(boolean encryptRequest) {
        this.encryptRequest = encryptRequest;
    }

    public void setElementsToEncrypt(List<QName> elementsToEncrypt) {
        this.elementsToEncrypt = elementsToEncrypt;
    }

    public void addElementToEncrypt(QName elementToEncrypt) {
        this.elementsToEncrypt.add(elementToEncrypt);
    }

    public void setElementsToSign(List<QName> elementsToSign) {
        this.elementsToSign = elementsToSign;
    }

    public void addElementToSign(QName elementToSign) {
        this.elementsToSign.add(elementToSign);
    }

    public boolean isEncryptSymmetricKey() {
        return this.encryptSymmetricKey;
    }

    public void setEncryptSymmetricKey(boolean encryptSymmetricKey) {
        this.encryptSymmetricKey = encryptSymmetricKey;
    }

    public SecretKey getSymmetricKey() {
        return this.symmetricKey;
    }

    public void setSymmetricKey(SecretKey symmetricKey) {
        this.symmetricKey = symmetricKey;
    }

    final class XmlSecStaxOutInterceptorInternal
    extends AbstractPhaseInterceptor<Message> {
        public XmlSecStaxOutInterceptorInternal() {
            super("pre-stream-ending");
        }

        @Override
        public void handleMessage(Message mc) throws Fault {
            try {
                OutputStream os;
                XMLStreamWriter xtw = mc.getContent(XMLStreamWriter.class);
                if (xtw != null) {
                    xtw.writeEndDocument();
                    xtw.flush();
                    xtw.close();
                }
                if ((os = (OutputStream)mc.get(OUTPUT_STREAM_HOLDER)) != null) {
                    mc.setContent(OutputStream.class, os);
                }
                mc.removeContent(XMLStreamWriter.class);
            }
            catch (XMLStreamException e) {
                throw new Fault(e);
            }
        }
    }
}

