/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.common.TrustValidator;
import org.apache.cxf.rs.security.xml.EncryptionProperties;
import org.apache.cxf.rs.security.xml.SignatureProperties;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.InboundXMLSec;
import org.apache.xml.security.stax.ext.XMLSec;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.securityEvent.AlgorithmSuiteSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;

public class XmlSecInInterceptor
implements PhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(XmlSecInInterceptor.class);
    private Set<String> before = new HashSet<String>();
    private Set<String> after = new HashSet<String>();
    private EncryptionProperties encryptionProperties;
    private SignatureProperties sigProps;
    private String phase;
    private String decryptionAlias;
    private String signatureVerificationAlias;

    public XmlSecInInterceptor() {
        this.setPhase("post-stream");
        this.getAfter().add(StaxInInterceptor.class.getName());
    }

    @Override
    public void handleFault(Message message) {
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        InputStream is;
        String method = (String)message.get("org.apache.cxf.request.method");
        if ("GET".equals(method)) {
            return;
        }
        Message outMs = message.getExchange().getOutMessage();
        Message inMsg = outMs == null ? message : outMs.getExchange().getInMessage();
        XMLStreamReader originalXmlStreamReader = inMsg.getContent(XMLStreamReader.class);
        if (originalXmlStreamReader == null && (is = inMsg.getContent(InputStream.class)) != null) {
            originalXmlStreamReader = StaxUtils.createXMLStreamReader(is);
        }
        try {
            XMLSecurityProperties properties = new XMLSecurityProperties();
            this.configureDecryptionKeys(inMsg, properties);
            Crypto signatureCrypto = this.getSignatureCrypto(inMsg);
            this.configureSignatureKeys(signatureCrypto, inMsg, properties);
            SecurityEventListener securityEventListener = this.configureSecurityEventListener(signatureCrypto, inMsg, properties);
            InboundXMLSec inboundXMLSec = XMLSec.getInboundWSSec((XMLSecurityProperties)properties);
            XMLStreamReader newXmlStreamReader = inboundXMLSec.processInMessage(originalXmlStreamReader, null, securityEventListener);
            inMsg.setContent(XMLStreamReader.class, newXmlStreamReader);
        }
        catch (XMLStreamException e) {
            this.throwFault(e.getMessage(), e);
        }
        catch (XMLSecurityException e) {
            this.throwFault(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            this.throwFault(e.getMessage(), e);
        }
        catch (UnsupportedCallbackException e) {
            this.throwFault(e.getMessage(), e);
        }
    }

    private void configureDecryptionKeys(Message message, XMLSecurityProperties properties) throws IOException, UnsupportedCallbackException, WSSecurityException {
        String cryptoKey = null;
        String propKey = null;
        if (SecurityUtils.isSignedAndEncryptedTwoWay(message)) {
            cryptoKey = "ws-security.signature.crypto";
            propKey = "ws-security.signature.properties";
        } else {
            cryptoKey = "ws-security.encryption.crypto";
            propKey = "ws-security.encryption.properties";
        }
        Crypto crypto = null;
        try {
            crypto = new CryptoLoader().getCrypto(message, cryptoKey, propKey);
        }
        catch (Exception ex) {
            this.throwFault("Crypto can not be loaded", ex);
        }
        if (crypto != null && this.decryptionAlias != null) {
            CallbackHandler callback = SecurityUtils.getCallbackHandler(message, this.getClass());
            WSPasswordCallback passwordCallback = new WSPasswordCallback(this.decryptionAlias, 1);
            callback.handle(new Callback[]{passwordCallback});
            PrivateKey privateKey = crypto.getPrivateKey(this.decryptionAlias, passwordCallback.getPassword());
            properties.setDecryptionKey((Key)privateKey);
        }
    }

    private Crypto getSignatureCrypto(Message message) {
        String cryptoKey = null;
        String propKey = null;
        if (SecurityUtils.isSignedAndEncryptedTwoWay(message)) {
            cryptoKey = "ws-security.encryption.crypto";
            propKey = "ws-security.encryption.properties";
        } else {
            cryptoKey = "ws-security.signature.crypto";
            propKey = "ws-security.signature.properties";
        }
        try {
            return new CryptoLoader().getCrypto(message, cryptoKey, propKey);
        }
        catch (Exception ex) {
            this.throwFault("Crypto can not be loaded", ex);
            return null;
        }
    }

    private void configureSignatureKeys(Crypto sigCrypto, Message message, XMLSecurityProperties properties) throws IOException, UnsupportedCallbackException, WSSecurityException {
        if (sigCrypto != null && this.signatureVerificationAlias != null) {
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(this.signatureVerificationAlias);
            X509Certificate[] certs = sigCrypto.getX509Certificates(cryptoType);
            if (certs != null && certs.length > 0) {
                properties.setSignatureVerificationKey((Key)certs[0].getPublicKey());
            }
        }
    }

    protected SecurityEventListener configureSecurityEventListener(final Crypto sigCrypto, Message msg, XMLSecurityProperties securityProperties) {
        final LinkedList incomingSecurityEventList = new LinkedList();
        SecurityEventListener securityEventListener = new SecurityEventListener(){

            public void registerSecurityEvent(SecurityEvent securityEvent) throws XMLSecurityException {
                if (securityEvent.getSecurityEventType() == SecurityEventConstants.AlgorithmSuite) {
                    if (XmlSecInInterceptor.this.encryptionProperties != null) {
                        XmlSecInInterceptor.this.checkEncryptionAlgorithms((AlgorithmSuiteSecurityEvent)securityEvent);
                    }
                    if (XmlSecInInterceptor.this.sigProps != null) {
                        XmlSecInInterceptor.this.checkSignatureAlgorithms((AlgorithmSuiteSecurityEvent)securityEvent);
                    }
                } else if (securityEvent.getSecurityEventType() != SecurityEventConstants.EncryptedKeyToken && securityEvent instanceof TokenSecurityEvent) {
                    XmlSecInInterceptor.this.checkSignatureTrust(sigCrypto, (TokenSecurityEvent)securityEvent);
                }
                incomingSecurityEventList.add(securityEvent);
            }
        };
        msg.getExchange().put(SecurityEvent.class.getName() + ".in", incomingSecurityEventList);
        msg.put(SecurityEvent.class.getName() + ".in", incomingSecurityEventList);
        return securityEventListener;
    }

    private void checkEncryptionAlgorithms(AlgorithmSuiteSecurityEvent event) throws XMLSecurityException {
        if (XMLSecurityConstants.Enc.equals((Object)event.getAlgorithmUsage()) && this.encryptionProperties.getEncryptionSymmetricKeyAlgo() != null && !this.encryptionProperties.getEncryptionSymmetricKeyAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The symmetric encryption algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if ((XMLSecurityConstants.Sym_Key_Wrap.equals((Object)event.getAlgorithmUsage()) || XMLSecurityConstants.Asym_Key_Wrap.equals((Object)event.getAlgorithmUsage())) && this.encryptionProperties.getEncryptionKeyTransportAlgo() != null && !this.encryptionProperties.getEncryptionKeyTransportAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The key transport algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if (XMLSecurityConstants.EncDig.equals((Object)event.getAlgorithmUsage()) && this.encryptionProperties.getEncryptionDigestAlgo() != null && !this.encryptionProperties.getEncryptionDigestAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The encryption digest algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
    }

    private void checkSignatureAlgorithms(AlgorithmSuiteSecurityEvent event) throws XMLSecurityException {
        if (XMLSecurityConstants.Asym_Sig.equals((Object)event.getAlgorithmUsage()) || XMLSecurityConstants.Sym_Sig.equals((Object)event.getAlgorithmUsage()) && this.sigProps.getSignatureAlgo() != null && !this.sigProps.getSignatureAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The signature algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if (XMLSecurityConstants.SigDig.equals((Object)event.getAlgorithmUsage()) && this.sigProps.getSignatureDigestAlgo() != null && !this.sigProps.getSignatureDigestAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The signature digest algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if (XMLSecurityConstants.SigC14n.equals((Object)event.getAlgorithmUsage()) && this.sigProps.getSignatureC14nMethod() != null && !this.sigProps.getSignatureC14nMethod().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The signature c14n algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if (XMLSecurityConstants.SigTransform.equals((Object)event.getAlgorithmUsage()) && this.sigProps.getSignatureC14nTransform() != null && !this.sigProps.getSignatureC14nTransform().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The signature transformation algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
    }

    private void checkSignatureTrust(Crypto sigCrypto, TokenSecurityEvent<?> event) throws XMLSecurityException {
        SecurityToken token = event.getSecurityToken();
        if (token != null) {
            X509Certificate[] certs = token.getX509Certificates();
            PublicKey publicKey = token.getPublicKey();
            X509Certificate cert = null;
            if (certs != null && certs.length > 0) {
                cert = certs[0];
            }
            try {
                new TrustValidator().validateTrust(sigCrypto, cert, publicKey);
            }
            catch (WSSecurityException e) {
                throw new XMLSecurityException("empty", new Object[]{"Error during Signature Trust validation: " + e.getMessage()});
            }
        }
    }

    protected void throwFault(String error, Exception ex) {
        LOG.warning(error);
        Response response = JAXRSUtils.toResponseBuilder(400).entity((Object)error).build();
        throw ExceptionUtils.toBadRequestException(null, response);
    }

    @Override
    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    @Override
    public Set<String> getAfter() {
        return this.after;
    }

    public void setAfter(Set<String> after) {
        this.after = after;
    }

    @Override
    public Set<String> getBefore() {
        return this.before;
    }

    public void setBefore(Set<String> before) {
        this.before = before;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public void setEncryptionProperties(EncryptionProperties properties) {
        this.encryptionProperties = properties;
    }

    public void setSignatureProperties(SignatureProperties properties) {
        this.sigProps = properties;
    }

    public String getDecryptionAlias() {
        return this.decryptionAlias;
    }

    public void setDecryptionAlias(String decryptionAlias) {
        this.decryptionAlias = decryptionAlias;
    }

    public String getSignatureVerificationAlias() {
        return this.signatureVerificationAlias;
    }

    public void setSignatureVerificationAlias(String signatureVerificationAlias) {
        this.signatureVerificationAlias = signatureVerificationAlias;
    }
}

