/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.services.AbstractTokenService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Path(value="/token")
public class AccessTokenService
extends AbstractTokenService {
    private List<AccessTokenGrantHandler> grantHandlers = new LinkedList<AccessTokenGrantHandler>();
    private List<String> audiences = new LinkedList<String>();

    public void setGrantHandlers(List<AccessTokenGrantHandler> handlers) {
        this.grantHandlers = handlers;
    }

    public void setGrantHandler(AccessTokenGrantHandler handler) {
        this.grantHandlers.add(handler);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response handleTokenRequest(MultivaluedMap<String, String> params) {
        Client client = this.authenticateClientIfNeeded(params);
        if (!OAuthUtils.isGrantSupportedForClient(client, this.isCanSupportPublicClients(), (String)params.getFirst((Object)"grant_type"))) {
            return this.createErrorResponse(params, "unauthorized_client");
        }
        try {
            this.checkAudience(params);
        }
        catch (OAuthServiceException ex) {
            return super.createErrorResponseFromBean(ex.getError());
        }
        AccessTokenGrantHandler handler = this.findGrantHandler(params);
        if (handler == null) {
            return this.createErrorResponse(params, "unsupported_grant_type");
        }
        ServerAccessToken serverToken = null;
        try {
            serverToken = handler.createAccessToken(client, params);
        }
        catch (OAuthServiceException ex) {
            return this.handleException(ex, "invalid_grant");
        }
        if (serverToken == null) {
            return this.createErrorResponse(params, "invalid_grant");
        }
        ClientAccessToken clientToken = new ClientAccessToken(serverToken.getTokenType(), serverToken.getTokenKey());
        clientToken.setRefreshToken(serverToken.getRefreshToken());
        if (this.isWriteOptionalParameters()) {
            clientToken.setExpiresIn(serverToken.getExpiresIn());
            List<OAuthPermission> perms = serverToken.getScopes();
            if (!perms.isEmpty()) {
                clientToken.setApprovedScope(OAuthUtils.convertPermissionsToScope(perms));
            }
            clientToken.setParameters(serverToken.getParameters());
        }
        return Response.ok((Object)clientToken).header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache").build();
    }

    protected void checkAudience(MultivaluedMap<String, String> params) {
        if (this.audiences.isEmpty()) {
            return;
        }
        String audienceParam = (String)params.getFirst((Object)"audience");
        if (audienceParam == null) {
            throw new OAuthServiceException(new OAuthError("invalid_request"));
        }
        try {
            new URL(audienceParam);
        }
        catch (MalformedURLException ex) {
            throw new OAuthServiceException(new OAuthError("invalid_request"));
        }
        if (!this.audiences.contains(audienceParam)) {
            throw new OAuthServiceException(new OAuthError("access_denied"));
        }
    }

    protected AccessTokenGrantHandler findGrantHandler(MultivaluedMap<String, String> params) {
        String grantType = (String)params.getFirst((Object)"grant_type");
        if (grantType != null) {
            AuthorizationCodeGrantHandler handler;
            for (AccessTokenGrantHandler handler2 : this.grantHandlers) {
                if (!handler2.getSupportedGrantTypes().contains(grantType)) continue;
                return handler2;
            }
            if (this.grantHandlers.size() == 0 && (handler = new AuthorizationCodeGrantHandler()).getSupportedGrantTypes().contains(grantType)) {
                handler.setDataProvider((AuthorizationCodeDataProvider)super.getDataProvider());
                return handler;
            }
        }
        return null;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }
}

