/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.impl.ServletRequestPropertyHolder;
import org.apache.cxf.message.Message;

public final class PropertyHolderFactory {
    private PropertyHolderFactory() {
    }

    public static PropertyHolder getPropertyHolder(Message m) {
        return m.containsKey("HTTP.REQUEST") ? new ServletRequestPropertyHolder(m) : new MessagePropertyHolder(m);
    }

    private static class MessagePropertyHolder
    implements PropertyHolder {
        private static final String PROPERTY_KEY = "jaxrs.filter.properties";
        private Message m;
        private Map<String, Object> props;

        public MessagePropertyHolder(Message m) {
            this.m = m;
            this.props = CastUtils.cast((Map)m.get(PROPERTY_KEY));
        }

        @Override
        public Object getProperty(String name) {
            return this.props == null ? null : this.props.get(name);
        }

        @Override
        public void removeProperty(String name) {
            if (this.props != null) {
                this.props.remove(name);
            }
        }

        @Override
        public void setProperty(String name, Object value) {
            if (this.props == null) {
                this.props = new HashMap<String, Object>();
                this.m.put(PROPERTY_KEY, this.props);
            }
            if (value == null) {
                this.removeProperty(name);
            } else {
                this.props.put(name, value);
            }
        }

        @Override
        public Collection<String> getPropertyNames() {
            return this.props == null ? Collections.emptyList() : Collections.unmodifiableSet(this.props.keySet());
        }
    }

    public static interface PropertyHolder {
        public Object getProperty(String var1);

        public void removeProperty(String var1);

        public void setProperty(String var1, Object var2);

        public Collection<String> getPropertyNames();
    }
}

