/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.X509Token;
import org.w3c.dom.Element;

public class X509TokenPolicyValidator
extends AbstractTokenPolicyValidator
implements TokenPolicyValidator {
    private static final String X509_V3_VALUETYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    private static final String PKI_VALUETYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";

    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "X509Token");
        if (!ais.isEmpty()) {
            this.parsePolicies(ais, message, results);
            this.assertPolicy(aim, "WssX509PkiPathV1Token10");
            this.assertPolicy(aim, "WssX509PkiPathV1Token11");
            this.assertPolicy(aim, "WssX509V1Token10");
            this.assertPolicy(aim, "WssX509V1Token11");
            this.assertPolicy(aim, "WssX509V3Token10");
            this.assertPolicy(aim, "WssX509V3Token11");
        }
        return true;
    }

    private void parsePolicies(Collection<AssertionInfo> ais, Message message, List<WSSecurityEngineResult> results) {
        List bstResults = WSSecurityUtil.fetchAllActionResults(results, (int)4096);
        for (AssertionInfo ai : ais) {
            X509Token x509TokenPolicy = (X509Token)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired((AbstractToken)x509TokenPolicy, message)) continue;
            if (bstResults.isEmpty()) {
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                continue;
            }
            if (this.checkTokenType(x509TokenPolicy.getTokenType(), bstResults)) continue;
            ai.setNotAsserted("An incorrect X.509 Token Type is detected");
        }
    }

    private boolean checkTokenType(X509Token.TokenType tokenType, List<WSSecurityEngineResult> bstResults) {
        if (bstResults.isEmpty()) {
            return false;
        }
        String requiredType = X509_V3_VALUETYPE;
        if (tokenType == X509Token.TokenType.WssX509PkiPathV1Token10 || tokenType == X509Token.TokenType.WssX509PkiPathV1Token11) {
            requiredType = PKI_VALUETYPE;
        }
        for (WSSecurityEngineResult result : bstResults) {
            String type;
            BinarySecurity binarySecurityToken = (BinarySecurity)result.get((Object)"binary-security-token");
            if (binarySecurityToken == null || !requiredType.equals(type = binarySecurityToken.getValueType())) continue;
            return true;
        }
        return false;
    }
}

