/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.CommandInterfaceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ToolTestBase
extends Assert {
    protected PrintStream oldStdErr;
    protected PrintStream oldStdOut;
    protected ByteArrayOutputStream errOut = new ByteArrayOutputStream();
    protected ByteArrayOutputStream stdOut = new ByteArrayOutputStream();

    @Before
    public void setUp() {
        CommandInterfaceUtils.setTestInProgress(true);
        this.oldStdErr = System.err;
        this.oldStdOut = System.out;
        System.setErr(new PrintStream(this.errOut));
        System.setOut(new PrintStream(this.stdOut));
    }

    @After
    public void tearDown() {
        System.setErr(this.oldStdErr);
        System.setOut(this.oldStdOut);
    }

    protected String getStdOut() {
        return new String(this.stdOut.toByteArray());
    }

    protected String getStdErr() {
        return new String(this.errOut.toByteArray());
    }

    protected String getLocation(String wsdlFile) throws Exception {
        File output = new File(((Object)((Object)this)).getClass().getResource(".").toURI());
        if (!(output = new File(output, "resources")).exists()) {
            FileUtils.mkDir(output);
        }
        return new File(output, wsdlFile).toString();
    }
}

