/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.validation;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.validation.ResponseConstraintViolationException;

@Provider
public class ValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private static final Logger LOG = LogUtils.getL7dLogger(ValidationExceptionMapper.class);

    public Response toResponse(ValidationException exception) {
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException constraint = (ConstraintViolationException)exception;
            boolean isResponseException = constraint instanceof ResponseConstraintViolationException;
            for (ConstraintViolation violation : constraint.getConstraintViolations()) {
                LOG.log(Level.WARNING, violation.getRootBeanClass().getSimpleName() + "." + violation.getPropertyPath() + ": " + violation.getMessage());
            }
            if (isResponseException) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }
}

