/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.validation;

import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.validation.ValidationProvider;

public class JAXRSValidationInvoker
extends JAXRSInvoker {
    private volatile ValidationProvider provider;
    private boolean validateServiceObject = true;

    @Override
    public Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        MessageContentsList list;
        Message message = JAXRSUtils.getCurrentMessage();
        ValidationProvider theProvider = this.getProvider(message);
        if (this.isValidateServiceObject()) {
            theProvider.validateBean(serviceObject);
        }
        theProvider.validateParameters(serviceObject, m, params.toArray());
        Object response = super.invoke(exchange, serviceObject, m, params);
        if (response instanceof MessageContentsList && (list = (MessageContentsList)response).size() == 1) {
            Object entity = list.get(0);
            if (entity instanceof Response) {
                theProvider.validateReturnValue(serviceObject, m, ((Response)entity).getEntity());
            } else {
                theProvider.validateReturnValue(serviceObject, m, entity);
            }
        }
        return response;
    }

    protected ValidationProvider getProvider(Message message) {
        if (this.provider == null) {
            Object prop = message.getContextualProperty(ValidationProvider.class.getName());
            this.provider = prop != null ? (ValidationProvider)prop : new ValidationProvider();
        }
        return this.provider;
    }

    public void setProvider(ValidationProvider provider) {
        this.provider = provider;
    }

    public boolean isValidateServiceObject() {
        return this.validateServiceObject;
    }

    public void setValidateServiceObject(boolean validateServiceObject) {
        this.validateServiceObject = validateServiceObject;
    }
}

