/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public abstract class AbstractResourceInfo {
    private static final String FIELD_PROXY_MAP = "jaxrs-field-proxy-map";
    private static final String SETTER_PROXY_MAP = "jaxrs-setter-proxy-map";
    private static final String CONSTRUCTOR_PROXY_MAP = "jaxrs-constructor-proxy-map";
    protected boolean root;
    protected Class<?> resourceClass;
    protected Class<?> serviceClass;
    private Map<Class<?>, List<Field>> contextFields;
    private Map<Class<?>, Map<Class<?>, Method>> contextMethods;
    private Bus bus;
    private boolean constructorProxiesAvailable;
    private boolean contextsAvailable;

    protected AbstractResourceInfo(Bus bus) {
        this.bus = bus;
    }

    protected AbstractResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot, boolean checkContexts, Bus bus) {
        this(resourceClass, serviceClass, isRoot, checkContexts, null, bus);
    }

    protected AbstractResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot, boolean checkContexts, Map<Class<?>, ThreadLocalProxy<?>> constructorProxies, Bus bus) {
        this.bus = bus;
        this.serviceClass = serviceClass;
        this.resourceClass = resourceClass;
        this.root = isRoot;
        if (checkContexts && resourceClass != null) {
            this.findContexts(serviceClass, constructorProxies);
        }
    }

    private void findContexts(Class<?> cls, Map<Class<?>, ThreadLocalProxy<?>> constructorProxies) {
        this.findContextFields(cls);
        this.findContextSetterMethods(cls);
        if (constructorProxies != null) {
            Map<Class<?>, Map<Class<?>, ThreadLocalProxy<?>>> proxies = this.getConstructorProxyMap(true);
            proxies.put(this.serviceClass, constructorProxies);
            this.constructorProxiesAvailable = true;
        }
        this.contextsAvailable = this.contextFields != null && !this.contextFields.isEmpty() || this.contextMethods != null && !this.contextMethods.isEmpty() || this.constructorProxiesAvailable;
    }

    public boolean contextsAvailable() {
        return this.contextsAvailable;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setResourceClass(Class<?> rClass) {
        this.resourceClass = rClass;
        if (this.serviceClass.isInterface() && this.resourceClass != null && !this.resourceClass.isInterface()) {
            this.findContexts(this.resourceClass, null);
        }
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    private void findContextFields(Class<?> cls) {
        if (cls == Object.class || cls == null) {
            return;
        }
        for (Field f : cls.getDeclaredFields()) {
            for (Annotation a : f.getAnnotations()) {
                if (a.annotationType() != Context.class) continue;
                this.contextFields = this.addContextField(this.contextFields, f);
                if (f.getType() == Application.class) continue;
                this.addToMap(this.getFieldProxyMap(true), f, InjectionUtils.createThreadLocalProxy(f.getType()));
            }
        }
        this.findContextFields(cls.getSuperclass());
    }

    private <T> Map<Class<?>, Map<T, ThreadLocalProxy<?>>> getProxyMap(Class<T> keyCls, String prop, boolean create) {
        ConcurrentHashMap property = this.bus.getProperty(prop);
        if (property == null && create) {
            ConcurrentHashMap map = new ConcurrentHashMap(2);
            this.bus.setProperty(prop, map);
            property = map;
        }
        return property;
    }

    public Map<Class<?>, ThreadLocalProxy<?>> getConstructorProxies() {
        if (this.constructorProxiesAvailable) {
            return this.getConstructorProxyMap(false).get(this.serviceClass);
        }
        return null;
    }

    private Map<Class<?>, Map<Class<?>, ThreadLocalProxy<?>>> getConstructorProxyMap(boolean create) {
        ConcurrentHashMap property = this.bus.getProperty(CONSTRUCTOR_PROXY_MAP);
        if (property == null) {
            ConcurrentHashMap map = new ConcurrentHashMap(2);
            this.bus.setProperty(CONSTRUCTOR_PROXY_MAP, map);
            property = map;
        }
        return property;
    }

    private Map<Class<?>, Map<Field, ThreadLocalProxy<?>>> getFieldProxyMap(boolean create) {
        return this.getProxyMap(Field.class, FIELD_PROXY_MAP, create);
    }

    private Map<Class<?>, Map<Method, ThreadLocalProxy<?>>> getSetterProxyMap(boolean create) {
        return this.getProxyMap(Method.class, SETTER_PROXY_MAP, create);
    }

    private void findContextSetterMethods(Class<?> cls) {
        Class<?>[] interfaces;
        block0: for (Method m : cls.getMethods()) {
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
            for (Annotation a : m.getAnnotations()) {
                if (a.annotationType() != Context.class) continue;
                this.checkContextMethod(m);
                continue block0;
            }
        }
        for (Class<?> i : interfaces = cls.getInterfaces()) {
            this.findContextSetterMethods(i);
        }
        Class<?> superCls = cls.getSuperclass();
        if (superCls != null && superCls != Object.class) {
            this.findContextSetterMethods(superCls);
        }
    }

    private void checkContextMethod(Method m) {
        Class<?> type = m.getParameterTypes()[0];
        if (m.getName().equals("set" + type.getSimpleName())) {
            this.addContextMethod(type, m);
        }
    }

    public Map<Class<?>, Method> getContextMethods() {
        Map<Class<?>, Method> methods = this.contextMethods == null ? null : this.contextMethods.get(this.getServiceClass());
        return methods == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(methods);
    }

    private void addContextMethod(Class<?> contextClass, Method m) {
        if (this.contextMethods == null) {
            this.contextMethods = new HashMap();
        }
        this.addToMap(this.contextMethods, contextClass, m);
        if (m.getParameterTypes()[0] != Application.class) {
            this.addToMap(this.getSetterProxyMap(true), m, InjectionUtils.createThreadLocalProxy(m.getParameterTypes()[0]));
        }
    }

    public boolean isRoot() {
        return this.root;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<Field> getContextFields() {
        return this.getList(this.contextFields);
    }

    public ThreadLocalProxy<?> getContextFieldProxy(Field f) {
        return this.getProxy(this.getFieldProxyMap(true), f);
    }

    public ThreadLocalProxy<?> getContextSetterProxy(Method m) {
        return this.getProxy(this.getSetterProxyMap(true), m);
    }

    public abstract boolean isSingleton();

    public static void clearAllMaps() {
        Bus bus = BusFactory.getThreadDefaultBus(false);
        if (bus != null) {
            Object property = bus.getProperty(FIELD_PROXY_MAP);
            if (property != null) {
                ((Map)property).clear();
            }
            if ((property = bus.getProperty(SETTER_PROXY_MAP)) != null) {
                ((Map)property).clear();
            }
            if ((property = bus.getProperty(CONSTRUCTOR_PROXY_MAP)) != null) {
                ((Map)property).clear();
            }
        }
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.getFieldProxyMap(false));
        this.clearProxies(this.getSetterProxyMap(false));
        this.clearProxies(this.getConstructorProxyMap(false));
    }

    private <T> void clearProxies(Map<Class<?>, Map<T, ThreadLocalProxy<?>>> tlps) {
        Map<T, ThreadLocalProxy<?>> proxies;
        Map<T, ThreadLocalProxy<?>> map = proxies = tlps == null ? null : tlps.get(this.getServiceClass());
        if (proxies == null) {
            return;
        }
        for (ThreadLocalProxy<?> tlp : proxies.values()) {
            if (tlp == null) continue;
            tlp.remove();
        }
    }

    private Map<Class<?>, List<Field>> addContextField(Map<Class<?>, List<Field>> theFields, Field f) {
        ArrayList<Field> fields = (ArrayList<Field>)(theFields = theFields == null ? new HashMap() : theFields).get(this.serviceClass);
        if (fields == null) {
            fields = new ArrayList<Field>();
            theFields.put(this.serviceClass, fields);
        }
        if (!fields.contains(f)) {
            fields.add(f);
        }
        return theFields;
    }

    private <T, V> void addToMap(Map<Class<?>, Map<T, V>> theFields, T f, V proxy) {
        Map<T, V> proxies = theFields.get(this.serviceClass);
        if (proxies == null) {
            proxies = new HashMap<T, V>();
            theFields.put(this.serviceClass, proxies);
        }
        if (!proxies.containsKey(f)) {
            proxies.put(f, proxy);
        }
    }

    private List<Field> getList(Map<Class<?>, List<Field>> fields) {
        List<Field> ret = fields == null ? null : fields.get(this.getServiceClass());
        ret = ret != null ? Collections.unmodifiableList(ret) : Collections.emptyList();
        return ret;
    }

    private <T> ThreadLocalProxy<?> getProxy(Map<Class<?>, Map<T, ThreadLocalProxy<?>>> proxies, T key) {
        Map<T, ThreadLocalProxy<?>> theMap = proxies == null ? null : proxies.get(this.getServiceClass());
        ThreadLocalProxy<?> ret = null;
        if (theMap != null) {
            ret = theMap.get(key);
        }
        return ret;
    }
}

