/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.kerberos;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;

public class KerberosClient
implements Configurable {
    private static final Logger LOG = LogUtils.getL7dLogger(KerberosClient.class);
    String name = "default.kerberos-client";
    private String serviceName;
    private CallbackHandler callbackHandler;
    private String contextName;
    private WSSConfig wssConfig = WSSConfig.getNewInstance();

    @Deprecated
    public KerberosClient(Bus b) {
    }

    public KerberosClient() {
    }

    @Override
    public String getBeanName() {
        return this.name;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getJaasLoginModuleName() {
        return this.contextName;
    }

    public void setJaasLoginModuleName(String jaasLoginModuleName) {
        this.contextName = jaasLoginModuleName;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public SecurityToken requestSecurityToken() throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Requesting Kerberos ticket for " + this.serviceName + " using JAAS Login Module: " + this.getContextName());
        }
        KerberosSecurity bst = new KerberosSecurity(DOMUtils.createDocument());
        bst.retrieveServiceTicket(this.getContextName(), this.callbackHandler, this.serviceName);
        bst.addWSUNamespace();
        bst.setID(this.wssConfig.getIdAllocator().createSecureId("BST-", (Object)bst));
        SecurityToken token = new SecurityToken(bst.getID());
        token.setToken(bst.getElement());
        token.setWsuId(bst.getID());
        SecretKey secretKey = bst.getSecretKey();
        if (secretKey != null) {
            token.setSecret(secretKey.getEncoded());
        }
        String sha1 = Base64.encode((byte[])WSSecurityUtil.generateDigest((byte[])bst.getToken()));
        token.setSHA1(sha1);
        token.setTokenType(bst.getValueType());
        return token;
    }
}

