/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.xacml;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rt.security.xacml.DefaultXACMLRequestBuilder;
import org.apache.cxf.rt.security.xacml.XACMLRequestBuilder;
import org.apache.cxf.security.LoginSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.util.DOM2Writer;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xml.XMLObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractXACMLAuthorizingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractXACMLAuthorizingInterceptor.class);
    private XACMLRequestBuilder requestBuilder = new DefaultXACMLRequestBuilder();

    public AbstractXACMLAuthorizingInterceptor() {
        super("pre-invoke");
        OpenSAMLUtil.initSamlEngine();
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        block6: {
            SecurityContext sc = message.get(SecurityContext.class);
            if (sc instanceof LoginSecurityContext) {
                Principal principal = sc.getUserPrincipal();
                LoginSecurityContext loginSecurityContext = (LoginSecurityContext)sc;
                Set<Principal> principalRoles = loginSecurityContext.getUserRoles();
                ArrayList<String> roles = new ArrayList<String>();
                if (principalRoles != null) {
                    for (Principal p : principalRoles) {
                        if (p == principal) continue;
                        roles.add(p.getName());
                    }
                }
                try {
                    if (this.authorize(principal, roles, message)) {
                        return;
                    }
                    break block6;
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "Unauthorized: " + e.getMessage(), e);
                    throw new AccessDeniedException("Unauthorized");
                }
            }
            LOG.log(Level.FINE, "The SecurityContext was not an instance of LoginSecurityContext. No authorization is possible as a result");
        }
        throw new AccessDeniedException("Unauthorized");
    }

    public XACMLRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public void setRequestBuilder(XACMLRequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    protected boolean authorize(Principal principal, List<String> roles, Message message) throws Exception {
        RequestType request = this.requestBuilder.createRequest(principal, roles, message);
        if (LOG.isLoggable(Level.FINE)) {
            Document doc = DOMUtils.createDocument();
            Element requestElement = OpenSAMLUtil.toDom((XMLObject)request, (Document)doc);
            LOG.log(Level.FINE, DOM2Writer.nodeToString((Node)requestElement));
        }
        ResponseType response = this.performRequest(request, message);
        ResultType result = response.getResult();
        this.handleObligations(request, principal, message, result);
        List<String> resources = this.requestBuilder.getResources(message);
        if (result != null && result.getDecision().getDecision() == DecisionType.DECISION.Permit) {
            if (result.getResourceId() == null) {
                LOG.fine("XACML authorization permitted");
                return true;
            }
            for (String resource : resources) {
                if (!resource.equals(result.getResourceId())) continue;
                LOG.fine("XACML authorization permitted");
                return true;
            }
        }
        LOG.fine("XACML authorization not permitted:");
        if (result != null && result.getStatus() != null) {
            if (result.getStatus().getStatusCode() != null) {
                LOG.fine("XACML Status Code: " + result.getStatus().getStatusCode().getValue());
            }
            if (result.getStatus().getStatusMessage() != null) {
                LOG.fine("XACML Status Message: " + result.getStatus().getStatusMessage().getValue());
            }
        }
        return false;
    }

    public abstract ResponseType performRequest(RequestType var1, Message var2) throws Exception;

    protected void handleObligations(RequestType request, Principal principal, Message message, ResultType result) throws Exception {
    }
}

